const express = require('express');
const router = express.Router();
const viewController = require('../controllers/viewController');
const dashboardController = require('../controllers/dashboardController');
const updateController = require('../controllers/updateController');

// كل صفحة ليها endpoint لجلب الفورم أو إرسال الداتا
router.get('/view', viewController.getForm);
router.post('/view', viewController.submitForm);

router.get('/dashboard', dashboardController.getForm);
router.post('/dashboard', dashboardController.submitForm);

router.get('/update', updateController.getForm);
router.post('/update', updateController.submitForm);

module.exports = router;
