<?php
/**
 * Ultra Admin — Session+Step Router (sid & p) — DEBUG-SAFE
 * URL: index.php?sid=<LONG_TOKEN>&p=<STEP_NUMBER>
 * - يحترم ترتيب pages في settings.json
 * - UA filter + JS verify + (session_runtime.php) إن وجد
 * - debug=1: يعرض الأخطاء بدل 500
 * - diag=1: يُرجع JSON تشخيصي سريع
 */

header('X-Content-Type-Options: nosniff');
header('Cache-Control: no-store, no-cache, must-revalidate');

if (session_status() === PHP_SESSION_NONE) session_start();

/* ---------- switches ---------- */
$DEBUG = isset($_GET['debug']) && $_GET['debug']=='1';
if ($DEBUG) {
  ini_set('display_errors','1');
  ini_set('display_startup_errors','1');
  error_reporting(E_ALL);
} else {
  ini_set('display_errors','0');
  error_reporting(E_ALL);
}

/* ---------- helpers ---------- */
function ua_json($code,$msg){ if(!headers_sent()) header('Content-Type:text/plain; charset=utf-8',true,$code); echo $msg; exit; }
function ua_json_obj($code,$arr){ if(!headers_sent()) header('Content-Type: application/json; charset=utf-8',true,$code); echo json_encode($arr,JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE); exit; }
function ua_load_pages(){
  $path=__DIR__.'/settings.json';
  if(!is_file($path)) return [];
  $raw=@file_get_contents($path);
  if($raw===false || $raw==='') return [];
  $j=json_decode($raw,true);
  if(!is_array($j)) return [];
  $pages=is_array($j['pages']??null)?$j['pages']:[];
  $out=[];
  foreach($pages as $p){ if(!empty($p['php'])) $out[]=basename($p['php']); }
  return array_values(array_unique($out));
}

/* ---------- JS verify endpoint ---------- */
if (isset($_GET['verify_js']) && $_GET['verify_js']==='1') {
  $_SESSION['js_verified']=true;
  http_response_code(204);
  exit;
}

/* ---------- UA filter (خفيف) ---------- */
$ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
$bot_pattern       = '/\b(bot|crawl|spider|wget|curl|python|scrapy|phantom|checker)\b/i';
$browser_whitelist = '/\b(Chrome|Chromium|Firefox|Safari|Edg|OPR|Opera)\b/i';
$is_sus            = (bool)preg_match($bot_pattern,$ua);
if ($is_sus && !preg_match($browser_whitelist,$ua)) ua_json(403,'Forbidden');
if ($is_sus && preg_match('/Headless|HeadlessChrome|selenium|puppeteer/i',$ua)) {
  if (empty($_SESSION['js_verified'])) {
    ?>
    <!doctype html><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Verifying…</title>
    <style>body{font-family:system-ui;display:flex;align-items:center;justify-content:center;height:100vh;background:#f7fafc;margin:0}
    .box{background:#fff;padding:20px;border-radius:10px;box-shadow:0 4px 20px rgba(0,0,0,.06);text-align:center}</style>
    <div class="box">Verifying your browser…</div>
    <script>fetch(location.pathname+'?verify_js=1',{credentials:'same-origin'}).then(()=>location.reload());</script>
    <?php exit;
  }
}

/* ---------- session_runtime include (إن وجد) ---------- */
if (is_file(__DIR__.'/session_runtime.php')) {
  // أي تحذير لن يضرب 500 في الوضع العادي
  @include __DIR__.'/session_runtime.php';
}

/* ---------- build sid & order ---------- */
if (empty($_SESSION['ua_sid'])) {
  try { $_SESSION['ua_sid']=bin2hex(random_bytes(24)); }
  catch(Throwable $e){ $_SESSION['ua_sid']=bin2hex(openssl_random_pseudo_bytes(24)); }
}
$live_order = ua_load_pages();
if (!$live_order) ua_json(500,'No pages defined in settings.json');
$_SESSION['ua_order'] = $live_order;

/* ---------- diag endpoint ---------- */
if (isset($_GET['diag']) && $_GET['diag']=='1') {
  $sid = $_GET['sid'] ?? '(missing)';
  $p   = isset($_GET['p']) ? (int)$_GET['p'] : 0;
  $idx = max(0, $p-1);
  $target = $_SESSION['ua_order'][$idx] ?? null;
  $exists = $target ? is_file(__DIR__.'/'.$target) : false;
  ua_json_obj(200, [
    'sid_param'     => $sid,
    'sid_session'   => $_SESSION['ua_sid'] ?? null,
    'p'             => $p,
    'order'         => $_SESSION['ua_order'],
    'target'        => $target,
    'target_exists' => $exists,
    'session_runtime_present' => is_file(__DIR__.'/session_runtime.php'),
  ]);
}

/* ---------- normalize URL ---------- */
$sid = $_GET['sid'] ?? '';
$p   = isset($_GET['p']) ? (int)$_GET['p'] : 0;
$total = count($_SESSION['ua_order']);

if ($sid==='' || $sid!==$_SESSION['ua_sid'] || $p<1 || $p>$total) {
  $first = $total?1:0;
  if(!$total) ua_json(500,'No pages available');
  $u='index.php?sid='.rawurlencode($_SESSION['ua_sid']).'&p='.$first.($DEBUG?'&debug=1':'');
  header('Location: '.$u); exit;
}

/* ---------- target by step ---------- */
$idx = $p-1;
$target = $_SESSION['ua_order'][$idx] ?? null;
if (!$target) ua_json(400,'Bad step index');

if (!preg_match('/^page_[A-Za-z0-9]{8}\.php$/',$target)) {
  if ($DEBUG) ua_json(400,'Unexpected filename: '.$target);
  ua_json(400,'Bad target');
}
$target_path = __DIR__.'/'.$target;
if (!is_file($target_path)) {
  if ($DEBUG) ua_json(404,'Target file not found: '.$target);
  ua_json(404,'Page missing');
}

/* ---------- next helper ---------- */
$_SESSION['__UA_NEXT_URL'] = isset($_SESSION['ua_order'][$idx+1])
  ? 'index.php?sid='.$_SESSION['ua_sid'].'&p='.($p+1).($DEBUG?'&debug=1':'')
  : null;

/* ---------- Fatal catcher (لـ debug) ---------- */
if ($DEBUG) {
  register_shutdown_function(function(){
    $e = error_get_last();
    if ($e && in_array($e['type'], [E_ERROR,E_PARSE,E_CORE_ERROR,E_COMPILE_ERROR])) {
      if (!headers_sent()) header('Content-Type:text/plain; charset=utf-8',true,500);
      echo "FATAL in included page:\n".$e['message']."\nFile: ".$e['file']."\nLine: ".$e['line'];
    }
  });
}

/* ---------- include target safely ---------- */
if ($DEBUG) {
  include $target_path; // هيظهر أي خطأ
} else {
  ob_start();
  include $target_path;
  ob_end_flush();
}
exit;
