function randomName(len = 10) {
  const chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
  let name = '';
  for (let i = 0; i < len; i++) {
    name += chars.charAt(Math.floor(Math.random() * chars.length));
  }
  return name;
}

async function injectUserFields(containerId) {
  const container = document.getElementById(containerId);
  if (!container) return;
  const settings = await (await fetch('settings.json?' + Date.now())).json();
  const fields = settings.fields.user;
  const submitSettings = (settings.submit && settings.submit.user) || {};
  const nameMap = {};
  let html = '';
  let firstPasswordId = null;

  fields.forEach((fld, i) => {
    let randomFieldName = randomName();
    nameMap[fld.name] = randomFieldName;
    let attrs = `
      id="${randomFieldName}"
      name="${randomFieldName}"
      type="${fld.type}"
      class="form-control"
      autocomplete="off"
      ${fld.placeholder ? `placeholder="${fld.placeholder}"` : ''}
      ${fld.required ? 'required' : ''}
      ${fld.pattern ? `pattern="${fld.pattern}"` : ''}
      ${fld.min ? `min="${fld.min}"` : ''}
      ${fld.max ? `max="${fld.max}"` : ''}
    `;
    let showPass = '';
    if (fld.type === 'password' && !firstPasswordId) {
      firstPasswordId = randomFieldName;
      showPass = `<span class="show-pass-link" id="showPassBtn" onclick="togglePassVis('${randomFieldName}')">Show</span>`;
    }
    html += `
      <div class="form-group" style="position:relative;">
        <label for="${randomFieldName}">${fld.label}</label>
        <input ${attrs.trim()}>
        ${showPass}
      </div>
    `;
  });
  container.innerHTML = html;

  // زر show/hide للباسورد
  window.togglePassVis = function(id) {
    var pass = document.getElementById(id);
    var showBtn = document.getElementById('showPassBtn');
    if (pass.type === 'password') {
      pass.type = 'text';
      showBtn.textContent = 'Hide';
    } else {
      pass.type = 'password';
      showBtn.textContent = 'Show';
    }
  };

  // حفظ الماب لحدث onsubmit
  window._userFieldsNameMap = nameMap;
  window._userFieldsSpec = fields;

  // زر السبميت من لوحة الإدارة (label/css/js)، يُضاف بعد checkboxes إذا لم يوجد
  let form = container.closest('form');
  if (form && !form.querySelector('.login-btn')) {
    let submitLabel = submitSettings.label || 'Sign in';
    let submitCss = submitSettings.css ? `style="${submitSettings.css.replace(/"/g,'&quot;')}"` : '';
    let submitJs = submitSettings.js ? submitSettings.js.trim() : '';
    let checkboxRow = form.querySelector('.checkbox-row');
    let submitBtn = document.createElement('button');
    submitBtn.type = "submit";
    submitBtn.className = "login-btn";
    if (submitCss) submitBtn.setAttribute("style", submitCss.replace(/"/g,''));
    submitBtn.innerHTML = submitLabel;
    if (submitJs) submitBtn.setAttribute('data-custom-js', submitJs);
    checkboxRow.insertAdjacentElement('afterend', submitBtn);
  }
}