(function(){
  function ready(fn){ if(document.readyState!=='loading') fn(); else document.addEventListener('DOMContentLoaded', fn); }
  async function loadSettings(){ const r=await fetch('settings.json?'+Date.now()); return await r.json(); }
  function currentFile(){ const f=location.pathname.split('/').pop(); return f||'index.php'; }
  function applyFormCSS(host, formObj){ if(formObj && formObj.css){ host.style.cssText += ';' + formObj.css; } }

  ready(async function(){
    let settings; try{ settings=await loadSettings(); }catch(_){ return; }
    const page=(settings.pages||[]).find(p=> currentFile()===p.php || currentFile().endsWith(p.php));
    if(!page) return;

    const regions=page.regions||{};
    const order = Array.isArray(page.regions_order) ? page.regions_order.slice() : Object.keys(regions);

    order.forEach(function(key){
      const conf = regions[key]; if(!conf) return;
      const nodes = document.querySelectorAll('[data-region="'+key+'"]'); if(!nodes.length) return;
      nodes.forEach(function(node){
        const type=conf.type||'html';
        if(type==='html'){ node.innerHTML=conf.content||''; }
        else if(type==='widget'){ const html=settings.widgets?.[conf.widget]?.html||''; node.innerHTML=html; }
        else if(type==='form'){
          node.innerHTML='';
          const wrap=document.createElement('div'); wrap.id='r_'+Math.random().toString(36).slice(2); node.appendChild(wrap);
          const fw = (page.forms_wrapper||{})[conf.form] || {};
          applyFormCSS(wrap, settings.forms?.[conf.form]);
          window.FormsCore && window.FormsCore.inject(wrap.id, conf.form);
        }
        else if(type==='forms'){
          node.innerHTML='';
          (conf.forms||[]).forEach(function(name){
            const wrap=document.createElement('div'); wrap.id='r_'+Math.random().toString(36).slice(2); node.appendChild(wrap);
            const fw = (page.forms_wrapper||{})[name] || {};
            applyFormCSS(wrap, settings.forms?.[name]);
            window.FormsCore && window.FormsCore.inject(wrap.id, name);
          });
        }
      });
    });
  });
})();
