(function(){
  const hl=document.createElement('div');
  hl.style.cssText='position:fixed;z-index:999998;border:2px solid #2563EB;background:rgba(37,99,235,.08);pointer-events:none;display:none';
  const tip=document.createElement('div');
  tip.style.cssText='position:fixed;z-index:999999;background:#0b1220;color:#fff;font:12px/1.4 system-ui;padding:6px 8px;border-radius:8px;display:none';
  document.documentElement.appendChild(hl); document.documentElement.appendChild(tip);

  let curMode='inside';
  function modeFromKeys(e){ if(e.ctrlKey||e.metaKey) return 'replace'; if(e.altKey) return 'before'; if(e.shiftKey) return 'after'; return 'inside'; }
  function modeLabel(m){ return m==='before'?'Insert BEFORE': m==='after'?'Insert AFTER': m==='replace'?'REPLACE element':'Insert INSIDE (append)'; }
  function idx(el){let i=1;for(let s=el.previousElementSibling;s;s=s.previousElementSibling){ if(s.tagName===el.tagName) i++; } return i;}
  function xPath(el){ if(el.id) return '//*[@id="'+el.id+'"]'; const segs=[]; for(;el&&el.nodeType===1; el=el.parentElement){ segs.unshift(el.tagName.toLowerCase()+'['+idx(el)+']'); if(el.tagName.toLowerCase()==='html') break; } return '/'+segs.join('/'); }
  function cssPath(el){ const segs=[]; for(;el&&el.nodeType===1; el=el.parentElement){ segs.unshift(el.tagName.toLowerCase()+':nth-of-type('+idx(el)+')'); if(el.tagName.toLowerCase()==='html') break; } return segs.join(' > '); }
  function show(el, e){
    const r=el.getBoundingClientRect();
    hl.style.display='block'; hl.style.left=r.left+'px'; hl.style.top=r.top+'px'; hl.style.width=r.width+'px'; hl.style.height=r.height+'px';
    tip.style.display='block'; tip.textContent = modeLabel(curMode)+'  •  '+el.tagName.toLowerCase()+(el.id?('#'+el.id):'');
    tip.style.left=(Math.max(6, Math.min(window.innerWidth-260, e.clientX+12)))+'px';
    tip.style.top=(Math.max(6, e.clientY+12))+'px';
  }
  function hide(){ hl.style.display='none'; tip.style.display='none'; }

  document.addEventListener('mousemove',(e)=>{ curMode = modeFromKeys(e); const t=e.target; if(t===document.documentElement||t===document.body){ hide(); return; } show(t,e); },{capture:true});
  document.addEventListener('mouseout',(e)=>{ if(!e.relatedTarget) hide(); },{capture:true});
  document.addEventListener('keydown',(e)=>{ curMode = modeFromKeys(e); },{capture:true});
  document.addEventListener('keyup',(e)=>{ curMode = modeFromKeys(e); },{capture:true});

  document.addEventListener('click',(e)=>{
    e.preventDefault(); e.stopPropagation();
    const el=e.target;
    const payload={ type:'UA_PICK', xpath:xPath(el), css:cssPath(el), id:el.id||'', mode: curMode };
    hide();
    window.parent.postMessage(payload,'*');
  },{capture:true});

  document.addEventListener('keydown',(e)=>{ if(e.key==='Escape'){ hide(); window.parent.postMessage({type:'UA_PICK_CANCEL'},'*'); } },{capture:true});

  const header=document.createElement('div');
  header.style.cssText='position:fixed;left:6px;bottom:6px;z-index:1000000;background:#0b1220;color:#fff;padding:6px 8px;border-radius:8px;font:12px system-ui;opacity:.9';
  header.innerHTML='Click=inside • Alt=before • Shift=after • Ctrl/Cmd=replace';
  document.documentElement.appendChild(header);
})();
